/**
 * Enables a Promise to be resolved or rejected at a future time, outside of
 * the context of the Promise construction. Also exposes the `pending`,
 * `fulfilled`, or `rejected` state of the promise.
 */
export declare class Deferred<T> implements PromiseLike<T> {
    #private;
    readonly [Symbol.toStringTag] = "Deferred";
    readonly promise: Promise<T>;
    constructor();
    /**
     * @return `true` iff neither `resolve` nor `rejected` have been invoked
     */
    get pending(): boolean;
    /**
     * @return `true` iff `resolve` has been invoked
     */
    get fulfilled(): boolean;
    /**
     * @return `true` iff `rejected` has been invoked
     */
    get rejected(): boolean;
    /**
     * @return `true` iff `resolve` or `rejected` have been invoked
     */
    get settled(): boolean;
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    resolve(value: T): boolean;
    reject(reason?: Error | string): boolean;
    observe(p: Promise<T>): this;
    observeQuietly(p: Promise<T>): Deferred<T | undefined>;
}
