var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};

// src/text.tsx
import * as React from "react";

// src/utils/parse-margins.ts
function parseMargin({
  margin,
  marginTop,
  marginRight,
  marginBottom,
  marginLeft
}) {
  let mt = marginTop;
  let mr = marginRight;
  let mb = marginBottom;
  let ml = marginLeft;
  if (typeof margin === "number") {
    mt = margin;
    mr = margin;
    mb = margin;
    ml = margin;
  } else if (typeof margin === "string") {
    const values = margin.split(/\s+/);
    switch (values.length) {
      case 1:
        mt = values[0];
        mr = values[0];
        mb = values[0];
        ml = values[0];
        break;
      case 2:
        mt = values[0];
        mb = values[0];
        mr = values[1];
        ml = values[1];
        break;
      case 3:
        mt = values[0];
        mr = values[1];
        mb = values[2];
        ml = values[1];
        break;
      case 4:
        mt = values[0];
        mr = values[1];
        mb = values[2];
        ml = values[3];
        break;
      default:
        break;
    }
  }
  return { mt, mr, mb, ml };
}

// src/text.tsx
import { jsx } from "react/jsx-runtime";
var Text = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { style } = _b, props = __objRest(_b, ["style"]);
    var _a2, _b2;
    const margins = parseMargin({
      margin: style == null ? void 0 : style.margin,
      marginBottom: (_a2 = style == null ? void 0 : style.marginBottom) != null ? _a2 : "16px",
      marginTop: (_b2 = style == null ? void 0 : style.marginTop) != null ? _b2 : "16px",
      marginLeft: style == null ? void 0 : style.marginLeft,
      marginRight: style == null ? void 0 : style.marginRight
    });
    return /* @__PURE__ */ jsx(
      "p",
      __spreadProps(__spreadValues({}, props), {
        ref,
        style: __spreadProps(__spreadValues({
          fontSize: "14px",
          lineHeight: "24px"
        }, style), {
          marginBottom: margins.mb,
          marginTop: margins.mt,
          marginLeft: margins.ml,
          marginRight: margins.mr
        })
      })
    );
  }
);
Text.displayName = "Text";
export {
  Text
};
