"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BedrockRuntimeServiceExtension = void 0;
const semconv_1 = require("../semconv");
class BedrockRuntimeServiceExtension {
    requestPreSpanHook(request, config, diag) {
        switch (request.commandName) {
            case 'Converse':
                return this.requestPreSpanHookConverse(request, config, diag);
        }
        return {
            isIncoming: false,
        };
    }
    requestPreSpanHookConverse(request, config, diag) {
        let spanName = semconv_1.GEN_AI_OPERATION_NAME_VALUE_CHAT;
        const spanAttributes = {
            [semconv_1.ATTR_GEN_AI_SYSTEM]: semconv_1.GEN_AI_SYSTEM_VALUE_AWS_BEDROCK,
            [semconv_1.ATTR_GEN_AI_OPERATION_NAME]: semconv_1.GEN_AI_OPERATION_NAME_VALUE_CHAT,
        };
        const modelId = request.commandInput.modelId;
        if (modelId) {
            spanAttributes[semconv_1.ATTR_GEN_AI_REQUEST_MODEL] = modelId;
            if (spanName) {
                spanName += ` ${modelId}`;
            }
        }
        const inferenceConfig = request.commandInput.inferenceConfig;
        if (inferenceConfig) {
            const { maxTokens, temperature, topP, stopSequences } = inferenceConfig;
            if (maxTokens !== undefined) {
                spanAttributes[semconv_1.ATTR_GEN_AI_REQUEST_MAX_TOKENS] = maxTokens;
            }
            if (temperature !== undefined) {
                spanAttributes[semconv_1.ATTR_GEN_AI_REQUEST_TEMPERATURE] = temperature;
            }
            if (topP !== undefined) {
                spanAttributes[semconv_1.ATTR_GEN_AI_REQUEST_TOP_P] = topP;
            }
            if (stopSequences !== undefined) {
                spanAttributes[semconv_1.ATTR_GEN_AI_REQUEST_STOP_SEQUENCES] = stopSequences;
            }
        }
        return {
            spanName,
            isIncoming: false,
            spanAttributes,
        };
    }
    responseHook(response, span, tracer, config) {
        if (!span.isRecording()) {
            return;
        }
        switch (response.request.commandName) {
            case 'Converse':
                return this.responseHookConverse(response, span, tracer, config);
        }
    }
    responseHookConverse(response, span, tracer, config) {
        const { stopReason, usage } = response.data;
        if (usage) {
            const { inputTokens, outputTokens } = usage;
            if (inputTokens !== undefined) {
                span.setAttribute(semconv_1.ATTR_GEN_AI_USAGE_INPUT_TOKENS, inputTokens);
            }
            if (outputTokens !== undefined) {
                span.setAttribute(semconv_1.ATTR_GEN_AI_USAGE_OUTPUT_TOKENS, outputTokens);
            }
        }
        if (stopReason !== undefined) {
            span.setAttribute(semconv_1.ATTR_GEN_AI_RESPONSE_FINISH_REASONS, [stopReason]);
        }
    }
}
exports.BedrockRuntimeServiceExtension = BedrockRuntimeServiceExtension;
//# sourceMappingURL=bedrock-runtime.js.map