import { ArgumentMetadata, FileValidator, ParseUUIDPipe } from '@nestjs/common';
import { ValidationOptions } from 'class-validator';
import { DateTime } from 'luxon';
export declare class ParseMeUUIDPipe extends ParseUUIDPipe {
    transform(value: string, metadata: ArgumentMetadata): Promise<string>;
}
export declare class FileNotEmptyValidator extends FileValidator {
    private requiredFields;
    constructor(requiredFields: string[]);
    isValid(files?: any): boolean;
    buildErrorMessage(): string;
}
export declare class UUIDParamDto {
    id: string;
}
export interface OptionalOptions extends ValidationOptions {
    nullable?: boolean;
    emptyToNull?: boolean;
}
export declare function Optional({ nullable, emptyToNull, ...validationOptions }?: OptionalOptions): <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
export declare const ValidateHexColor: () => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
type UUIDOptions = {
    optional?: boolean;
    each?: boolean;
    nullable?: boolean;
};
export declare const ValidateUUID: (options?: UUIDOptions) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
type DateOptions = {
    optional?: boolean;
    nullable?: boolean;
    format?: 'date' | 'date-time';
};
export declare const ValidateDate: (options?: DateOptions) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
type BooleanOptions = {
    optional?: boolean;
};
export declare const ValidateBoolean: (options?: BooleanOptions) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
export declare const IsCronExpression: () => PropertyDecorator;
type IValue = {
    value: unknown;
};
export declare const toEmail: ({ value }: IValue) => unknown;
export declare const toSanitized: ({ value }: IValue) => string;
export declare const isValidInteger: (value: number, options: {
    min?: number;
    max?: number;
}) => value is number;
export declare function isDateStringFormat(value: unknown, format: string): boolean;
export declare function IsDateStringFormat(format: string, validationOptions?: ValidationOptions): PropertyDecorator;
export declare function MaxDateString(date: DateTime | (() => DateTime), validationOptions?: ValidationOptions): PropertyDecorator;
type IsIPRangeOptions = {
    requireCIDR?: boolean;
};
export declare function IsIPRange(options: IsIPRangeOptions, validationOptions?: ValidationOptions): PropertyDecorator;
export {};
