"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serialize = exports.mapJsonLine = exports.toAck = exports.fromAck = void 0;
const fromAck = (ack) => {
    const [type, updateId] = ack.split('|');
    return { type: type, updateId };
};
exports.fromAck = fromAck;
const toAck = ({ type, updateId }) => [type, updateId].join('|');
exports.toAck = toAck;
const mapJsonLine = (object) => JSON.stringify(object) + '\n';
exports.mapJsonLine = mapJsonLine;
const serialize = ({ type, updateId, data, }) => (0, exports.mapJsonLine)({ type, data, ack: (0, exports.toAck)({ type, updateId }) });
exports.serialize = serialize;
//# sourceMappingURL=sync.js.map