import { SyncItem } from 'src/dtos/sync.dto';
import { SyncAck } from 'src/types';
type Impossible<K extends keyof any> = {
    [P in K]: never;
};
type Exact<T, U extends T = T> = U & Impossible<Exclude<keyof U, keyof T>>;
export declare const fromAck: (ack: string) => SyncAck;
export declare const toAck: ({ type, updateId }: SyncAck) => string;
export declare const mapJsonLine: (object: unknown) => string;
export declare const serialize: <T extends keyof SyncItem, D extends SyncItem[T]>({ type, updateId, data, }: {
    type: T;
    updateId: string;
    data: Exact<SyncItem[T], D>;
}) => string;
export {};
