"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePagination = usePagination;
exports.paginationHelper = paginationHelper;
async function* usePagination(pageSize, getNextPage) {
    let hasNextPage = true;
    for (let skip = 0; hasNextPage; skip += pageSize) {
        const result = await getNextPage({ take: pageSize, skip });
        hasNextPage = result.hasNextPage;
        yield result.items;
    }
}
function paginationHelper(items, take) {
    const hasNextPage = items.length > take;
    items.splice(take);
    return { items, hasNextPage };
}
//# sourceMappingURL=pagination.js.map