export interface PaginationOptions {
    take: number;
    skip?: number;
}
export interface PaginationResult<T> {
    items: T[];
    hasNextPage: boolean;
}
export type Paginated<T> = Promise<PaginationResult<T>>;
export declare function usePagination<T>(pageSize: number, getNextPage: (pagination: PaginationOptions) => PaginationResult<T> | Paginated<T>): AsyncGenerator<T[], void, unknown>;
export declare function paginationHelper<Entity extends object>(items: Entity[], take: number): PaginationResult<Entity>;
