import { AssetType } from 'src/enum';
export declare const mimeTypes: {
    image: Record<string, string[]>;
    profile: Record<string, string[]>;
    sidecar: Record<string, string[]>;
    video: Record<string, string[]>;
    raw: Record<string, string[]>;
    isAsset: (filename: string) => boolean;
    isImage: (filename: string) => boolean;
    isWebSupportedImage: (filename: string) => boolean;
    isProfile: (filename: string) => boolean;
    isSidecar: (filename: string) => boolean;
    isVideo: (filename: string) => boolean;
    isRaw: (filename: string) => boolean;
    lookup: (filename: string) => string;
    toExtension: (mimeType: string) => string | undefined;
    assetType: (filename: string) => AssetType.IMAGE | AssetType.VIDEO | AssetType.OTHER;
    getSupportedFileExtensions: () => string[];
};
