import { Expression, ExpressionBuilder, ExpressionWrapper, Kysely, KyselyConfig, Nullable, Selectable, SelectQueryBuilder, Simplify } from 'kysely';
import postgres from 'postgres';
import { Exif, Person } from 'src/database';
import { DB } from 'src/db';
import { AssetFileType } from 'src/enum';
import { TimeBucketSize } from 'src/repositories/asset.repository';
import { AssetSearchBuilderOptions } from 'src/repositories/search.repository';
import { DatabaseConnectionParams } from 'src/types';
type Ssl = 'require' | 'allow' | 'prefer' | 'verify-full' | boolean | object;
export declare const asPostgresConnectionConfig: (params: DatabaseConnectionParams) => {
    host: string | undefined;
    port: number | undefined;
    username: string | undefined;
    password: string | undefined;
    database: string | undefined;
    ssl: Ssl | undefined;
};
export declare const getKyselyConfig: (params: DatabaseConnectionParams, options?: Partial<postgres.Options<Record<string, postgres.PostgresType>>>) => KyselyConfig;
export declare const asUuid: (id: string | Expression<string>) => import("kysely").RawBuilder<string>;
export declare const anyUuid: (ids: string[]) => import("kysely").RawBuilder<string>;
export declare const asVector: (embedding: number[]) => import("kysely").RawBuilder<string>;
export declare const unnest: (array: string[]) => import("kysely").RawBuilder<Record<string, string>>;
export declare const removeUndefinedKeys: <T extends object>(update: T, template: unknown) => T;
export declare function toJson<DB, TB extends keyof DB & string, T extends TB | Expression<unknown>>(eb: ExpressionBuilder<DB, TB>, table: T): ExpressionWrapper<DB, TB, Simplify<T extends TB ? Selectable<DB[T]> extends Nullable<infer N> ? N | null : Selectable<DB[T]> : T extends Expression<infer O> ? O extends Nullable<infer N> ? N | null : O : never>>;
export declare const ASSET_CHECKSUM_CONSTRAINT = "UQ_assets_owner_checksum";
export declare function withExif<O>(qb: SelectQueryBuilder<DB, 'assets', O>): SelectQueryBuilder<{
    exif: Nullable<import("src/db").Exif>;
    assets: import("src/db").Assets;
    users: import("../schema/tables/user.table").UserTable;
    memories: import("src/db").Memories;
    tags: import("src/db").Tags;
    activity: import("src/db").Activity;
    albums: import("src/db").Albums;
    albums_assets_assets: import("src/db").AlbumsAssetsAssets;
    albums_shared_users_users: import("src/db").AlbumsSharedUsersUsers;
    api_keys: import("src/db").ApiKeys;
    asset_faces: import("src/db").AssetFaces;
    asset_files: import("src/db").AssetFiles;
    asset_job_status: import("src/db").AssetJobStatus;
    asset_stack: import("src/db").AssetStack;
    assets_audit: import("src/db").AssetsAudit;
    audit: import("src/db").Audit;
    face_search: import("src/db").FaceSearch;
    geodata_places: import("src/db").GeodataPlaces;
    libraries: import("src/db").Libraries;
    memories_assets_assets: import("src/db").MemoriesAssetsAssets;
    migrations: import("src/db").Migrations;
    move_history: import("src/db").MoveHistory;
    naturalearth_countries: import("src/db").NaturalearthCountries;
    partners_audit: import("src/db").PartnersAudit;
    partners: import("src/db").Partners;
    person: import("src/db").Person;
    sessions: import("src/db").Sessions;
    session_sync_checkpoints: import("src/db").SessionSyncCheckpoints;
    shared_link__asset: import("src/db").SharedLinkAsset;
    shared_links: import("src/db").SharedLinks;
    smart_search: import("src/db").SmartSearch;
    socket_io_attachments: import("src/db").SocketIoAttachments;
    system_config: import("src/db").SystemConfig;
    system_metadata: import("src/db").SystemMetadata;
    tag_asset: import("src/db").TagAsset;
    tags_closure: import("src/db").TagsClosure;
    typeorm_metadata: import("src/db").TypeormMetadata;
    user_metadata: import("src/db").UserMetadata;
    users_audit: import("src/db").UsersAudit;
    "vectors.pg_vector_index_stat": import("src/db").VectorsPgVectorIndexStat;
    version_history: import("src/db").VersionHistory;
}, "exif" | "assets", O & {
    exifInfo: Exif | null;
}>;
export declare function withExifInner<O>(qb: SelectQueryBuilder<DB, 'assets', O>): SelectQueryBuilder<DB, "exif" | "assets", O & {
    exifInfo: Exif;
}>;
export declare function withSmartSearch<O>(qb: SelectQueryBuilder<DB, 'assets', O>): SelectQueryBuilder<{
    exif: import("src/db").Exif;
    assets: import("src/db").Assets;
    users: import("../schema/tables/user.table").UserTable;
    memories: import("src/db").Memories;
    tags: import("src/db").Tags;
    activity: import("src/db").Activity;
    albums: import("src/db").Albums;
    albums_assets_assets: import("src/db").AlbumsAssetsAssets;
    albums_shared_users_users: import("src/db").AlbumsSharedUsersUsers;
    api_keys: import("src/db").ApiKeys;
    asset_faces: import("src/db").AssetFaces;
    asset_files: import("src/db").AssetFiles;
    asset_job_status: import("src/db").AssetJobStatus;
    asset_stack: import("src/db").AssetStack;
    assets_audit: import("src/db").AssetsAudit;
    audit: import("src/db").Audit;
    face_search: import("src/db").FaceSearch;
    geodata_places: import("src/db").GeodataPlaces;
    libraries: import("src/db").Libraries;
    memories_assets_assets: import("src/db").MemoriesAssetsAssets;
    migrations: import("src/db").Migrations;
    move_history: import("src/db").MoveHistory;
    naturalearth_countries: import("src/db").NaturalearthCountries;
    partners_audit: import("src/db").PartnersAudit;
    partners: import("src/db").Partners;
    person: import("src/db").Person;
    sessions: import("src/db").Sessions;
    session_sync_checkpoints: import("src/db").SessionSyncCheckpoints;
    shared_link__asset: import("src/db").SharedLinkAsset;
    shared_links: import("src/db").SharedLinks;
    smart_search: Nullable<import("src/db").SmartSearch>;
    socket_io_attachments: import("src/db").SocketIoAttachments;
    system_config: import("src/db").SystemConfig;
    system_metadata: import("src/db").SystemMetadata;
    tag_asset: import("src/db").TagAsset;
    tags_closure: import("src/db").TagsClosure;
    typeorm_metadata: import("src/db").TypeormMetadata;
    user_metadata: import("src/db").UserMetadata;
    users_audit: import("src/db").UsersAudit;
    "vectors.pg_vector_index_stat": import("src/db").VectorsPgVectorIndexStat;
    version_history: import("src/db").VersionHistory;
}, "assets" | "smart_search", O & {
    smartSearch: {
        assetId: string;
        embedding: string;
    } | null;
}>;
export declare function withFaces(eb: ExpressionBuilder<DB, 'assets'>, withDeletedFace?: boolean): import("kysely").AliasedRawBuilder<{
    id: string;
    assetId: string;
    imageHeight: number;
    imageWidth: number;
    boundingBoxX1: number;
    boundingBoxX2: number;
    boundingBoxY1: number;
    boundingBoxY2: number;
    sourceType: import("src/enum").SourceType;
    personId: string | null;
    deletedAt: Date | null;
}[], "faces">;
export declare function withFiles(eb: ExpressionBuilder<DB, 'assets'>, type?: AssetFileType): import("kysely").AliasedRawBuilder<{
    id: string;
    path: string;
    type: AssetFileType;
}[], "files">;
export declare function withFacesAndPeople(eb: ExpressionBuilder<DB, 'assets'>, withDeletedFace?: boolean): import("kysely").AliasedRawBuilder<{
    id: string;
    assetId: string;
    imageHeight: number;
    imageWidth: number;
    boundingBoxX1: number;
    boundingBoxX2: number;
    boundingBoxY1: number;
    boundingBoxY2: number;
    sourceType: import("src/enum").SourceType;
    personId: string | null;
    deletedAt: Date | null;
    person: Person;
}[], "faces">;
export declare function hasPeople<O>(qb: SelectQueryBuilder<DB, 'assets', O>, personIds: string[]): SelectQueryBuilder<DB & {
    has_people: {
        assetId: string;
    };
}, "assets" | "has_people", O>;
export declare function hasTags<O>(qb: SelectQueryBuilder<DB, 'assets', O>, tagIds: string[]): SelectQueryBuilder<DB & {
    has_tags: {
        assetsId: string;
    };
}, "assets" | "has_tags", O>;
export declare function withOwner(eb: ExpressionBuilder<DB, 'assets'>): import("kysely").AliasedRawBuilder<{
    name: string;
    id: string;
    email: string;
    profileImagePath: string;
    profileChangedAt: Date;
} | null, "owner">;
export declare function withLibrary(eb: ExpressionBuilder<DB, 'assets'>): import("kysely").AliasedRawBuilder<{
    name: string;
    id: string;
    updateId: string;
    updatedAt: Date;
    deletedAt: Date | null;
    ownerId: string;
    createdAt: Date;
    exclusionPatterns: string[];
    importPaths: string[];
    refreshedAt: Date | null;
} | null, "library">;
export declare function withTags(eb: ExpressionBuilder<DB, 'assets'>): import("kysely").AliasedRawBuilder<{
    id: string;
    value: string;
    createdAt: Date;
    updatedAt: Date;
    color: string | null;
    parentId: string | null;
}[], "tags">;
export declare function truncatedDate<O>(size: TimeBucketSize): import("kysely").RawBuilder<O>;
export declare function withTagId<O>(qb: SelectQueryBuilder<DB, 'assets', O>, tagId: string): SelectQueryBuilder<DB, "assets", O>;
export declare function searchAssetBuilder(kysely: Kysely<DB>, options: AssetSearchBuilderOptions): SelectQueryBuilder<DB, "assets", {
    id: string;
    type: import("src/enum").AssetType;
    updateId: string;
    updatedAt: Date;
    isFavorite: boolean;
    deletedAt: Date | null;
    ownerId: string;
    libraryId: string | null;
    createdAt: Date;
    status: import("src/enum").AssetStatus;
    checksum: Buffer<ArrayBufferLike>;
    deviceAssetId: string;
    deviceId: string;
    duplicateId: string | null;
    duration: string | null;
    encodedVideoPath: string | null;
    fileCreatedAt: Date;
    fileModifiedAt: Date;
    isArchived: boolean;
    isExternal: boolean;
    isOffline: boolean;
    isVisible: boolean;
    livePhotoVideoId: string | null;
    localDateTime: Date;
    originalFileName: string;
    originalPath: string;
    sidecarPath: string | null;
    thumbhash: Buffer<ArrayBufferLike> | null;
    stackId: string | null;
} & Partial<Omit<unknown, "id" | "type" | "updateId" | "updatedAt" | "isFavorite" | "deletedAt" | "ownerId" | "libraryId" | "createdAt" | "status" | "checksum" | "deviceAssetId" | "deviceId" | "duplicateId" | "duration" | "encodedVideoPath" | "fileCreatedAt" | "fileModifiedAt" | "isArchived" | "isExternal" | "isOffline" | "isVisible" | "livePhotoVideoId" | "localDateTime" | "originalFileName" | "originalPath" | "sidecarPath" | "thumbhash" | "stackId">> & Partial<Omit<{
    exifInfo: Exif;
}, "id" | "type" | "updateId" | "updatedAt" | "isFavorite" | "deletedAt" | "ownerId" | "libraryId" | "createdAt" | "status" | "checksum" | "deviceAssetId" | "deviceId" | "duplicateId" | "duration" | "encodedVideoPath" | "fileCreatedAt" | "fileModifiedAt" | "isArchived" | "isExternal" | "isOffline" | "isVisible" | "livePhotoVideoId" | "localDateTime" | "originalFileName" | "originalPath" | "sidecarPath" | "thumbhash" | "stackId">> & Partial<Omit<{
    faces: {
        id: string;
        assetId: string;
        imageHeight: number;
        imageWidth: number;
        boundingBoxX1: number;
        boundingBoxX2: number;
        boundingBoxY1: number;
        boundingBoxY2: number;
        sourceType: import("src/enum").SourceType;
        personId: string | null;
        deletedAt: Date | null;
        person: Person;
    }[];
}, "exifInfo" | ("id" | "type" | "updateId" | "updatedAt" | "isFavorite" | "deletedAt" | "ownerId" | "libraryId" | "createdAt" | "status" | "checksum" | "deviceAssetId" | "deviceId" | "duplicateId" | "duration" | "encodedVideoPath" | "fileCreatedAt" | "fileModifiedAt" | "isArchived" | "isExternal" | "isOffline" | "isVisible" | "livePhotoVideoId" | "localDateTime" | "originalFileName" | "originalPath" | "sidecarPath" | "thumbhash" | "stackId")>> & Partial<Omit<unknown, "exifInfo" | "faces" | ("id" | "type" | "updateId" | "updatedAt" | "isFavorite" | "deletedAt" | "ownerId" | "libraryId" | "createdAt" | "status" | "checksum" | "deviceAssetId" | "deviceId" | "duplicateId" | "duration" | "encodedVideoPath" | "fileCreatedAt" | "fileModifiedAt" | "isArchived" | "isExternal" | "isOffline" | "isVisible" | "livePhotoVideoId" | "localDateTime" | "originalFileName" | "originalPath" | "sidecarPath" | "thumbhash" | "stackId")>>>;
export {};
