"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateConfig = exports.getConfig = exports.clearConfigCache = void 0;
const async_lock_1 = __importDefault(require("async-lock"));
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const js_yaml_1 = require("js-yaml");
const _ = __importStar(require("lodash"));
const config_1 = require("../config");
const system_config_dto_1 = require("../dtos/system-config.dto");
const enum_1 = require("../enum");
const misc_1 = require("./misc");
const asyncLock = new async_lock_1.default();
let config = null;
let lastUpdated = null;
const clearConfigCache = () => {
    config = null;
    lastUpdated = null;
};
exports.clearConfigCache = clearConfigCache;
const getConfig = async (repos, { withCache }) => {
    if (!withCache || !config) {
        const timestamp = lastUpdated;
        await asyncLock.acquire(enum_1.DatabaseLock[enum_1.DatabaseLock.GetSystemConfig], async () => {
            if (timestamp === lastUpdated) {
                config = await buildConfig(repos);
                lastUpdated = Date.now();
            }
        });
    }
    return config;
};
exports.getConfig = getConfig;
const updateConfig = async (repos, newConfig) => {
    const { metadataRepo } = repos;
    const partialConfig = {};
    for (const property of (0, misc_1.getKeysDeep)(config_1.defaults)) {
        const newValue = _.get(newConfig, property);
        const isEmpty = newValue === undefined || newValue === null || newValue === '';
        const defaultValue = _.get(config_1.defaults, property);
        const isEqual = newValue === defaultValue || _.isEqual(newValue, defaultValue);
        if (isEmpty || isEqual) {
            continue;
        }
        _.set(partialConfig, property, newValue);
    }
    await metadataRepo.set(enum_1.SystemMetadataKey.SYSTEM_CONFIG, partialConfig);
    return (0, exports.getConfig)(repos, { withCache: false });
};
exports.updateConfig = updateConfig;
const loadFromFile = async ({ metadataRepo, logger }, filepath) => {
    try {
        const file = await metadataRepo.readFile(filepath);
        return (0, js_yaml_1.load)(file.toString());
    }
    catch (error) {
        logger.error(`Unable to load configuration file: ${filepath}`);
        logger.error(error);
        throw error;
    }
};
const buildConfig = async (repos) => {
    const { configRepo, metadataRepo, logger } = repos;
    const { configFile } = configRepo.getEnv();
    const partial = configFile
        ? await loadFromFile(repos, configFile)
        : await metadataRepo.get(enum_1.SystemMetadataKey.SYSTEM_CONFIG);
    const rawConfig = _.cloneDeep(config_1.defaults);
    for (const property of (0, misc_1.getKeysDeep)(partial)) {
        _.set(rawConfig, property, _.get(partial, property));
    }
    const unknownKeys = _.cloneDeep(rawConfig);
    for (const property of (0, misc_1.getKeysDeep)(config_1.defaults)) {
        (0, misc_1.unsetDeep)(unknownKeys, property);
    }
    if (!_.isEmpty(unknownKeys)) {
        logger.warn(`Unknown keys found: ${JSON.stringify(unknownKeys, null, 2)}`);
    }
    const instance = (0, class_transformer_1.plainToInstance)(system_config_dto_1.SystemConfigDto, rawConfig);
    const errors = await (0, class_validator_1.validate)(instance);
    if (errors.length > 0) {
        if (configFile) {
            throw new Error(`Invalid value(s) in file: ${errors}`);
        }
        else {
            logger.error('Validation error', errors);
        }
    }
    const config = (0, class_transformer_1.instanceToPlain)(instance);
    if (config.server.externalDomain.length > 0) {
        config.server.externalDomain = new URL(config.server.externalDomain).origin;
    }
    if (!config.ffmpeg.acceptedVideoCodecs.includes(config.ffmpeg.targetVideoCodec)) {
        config.ffmpeg.acceptedVideoCodecs.push(config.ffmpeg.targetVideoCodec);
    }
    if (!config.ffmpeg.acceptedAudioCodecs.includes(config.ffmpeg.targetAudioCodec)) {
        config.ffmpeg.acceptedAudioCodecs.push(config.ffmpeg.targetAudioCodec);
    }
    return config;
};
//# sourceMappingURL=config.js.map