import { GeneratedImageType } from 'src/cores/storage.core';
import { AssetFile } from 'src/database';
import { BulkIdResponseDto } from 'src/dtos/asset-ids.response.dto';
import { UploadFieldName } from 'src/dtos/asset-media.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetFileType, AssetType, Permission } from 'src/enum';
import { AuthRequest } from 'src/middleware/auth.guard';
import { AccessRepository } from 'src/repositories/access.repository';
import { AssetRepository } from 'src/repositories/asset.repository';
import { EventRepository } from 'src/repositories/event.repository';
import { PartnerRepository } from 'src/repositories/partner.repository';
import { IBulkAsset, ImmichFile, UploadFile } from 'src/types';
export declare const getAssetFile: (files: AssetFile[], type: AssetFileType | GeneratedImageType) => AssetFile | undefined;
export declare const getAssetFiles: (files: AssetFile[]) => {
    fullsizeFile: AssetFile | undefined;
    previewFile: AssetFile | undefined;
    thumbnailFile: AssetFile | undefined;
};
export declare const addAssets: (auth: AuthDto, repositories: {
    access: AccessRepository;
    bulk: IBulkAsset;
}, dto: {
    parentId: string;
    assetIds: string[];
}) => Promise<BulkIdResponseDto[]>;
export declare const removeAssets: (auth: AuthDto, repositories: {
    access: AccessRepository;
    bulk: IBulkAsset;
}, dto: {
    parentId: string;
    assetIds: string[];
    canAlwaysRemove: Permission;
}) => Promise<BulkIdResponseDto[]>;
export type PartnerIdOptions = {
    userId: string;
    repository: PartnerRepository;
    timelineEnabled?: boolean;
};
export declare const getMyPartnerIds: ({ userId, repository, timelineEnabled }: PartnerIdOptions) => Promise<string[]>;
export type AssetHookRepositories = {
    asset: AssetRepository;
    event: EventRepository;
};
export declare const onBeforeLink: ({ asset: assetRepository, event: eventRepository }: AssetHookRepositories, { userId, livePhotoVideoId }: {
    userId: string;
    livePhotoVideoId: string;
}) => Promise<void>;
export declare const onBeforeUnlink: ({ asset: assetRepository }: AssetHookRepositories, { livePhotoVideoId }: {
    livePhotoVideoId: string;
}) => Promise<{
    id: string;
    type: AssetType;
    updateId: string;
    updatedAt: Date;
    isFavorite: boolean;
    deletedAt: Date | null;
    ownerId: string;
    libraryId: string | null;
    createdAt: Date;
    status: import("src/enum").AssetStatus;
    checksum: Buffer<ArrayBufferLike>;
    deviceAssetId: string;
    deviceId: string;
    duplicateId: string | null;
    duration: string | null;
    encodedVideoPath: string | null;
    fileCreatedAt: Date;
    fileModifiedAt: Date;
    isArchived: boolean;
    isExternal: boolean;
    isOffline: boolean;
    isVisible: boolean;
    livePhotoVideoId: string | null;
    localDateTime: Date;
    originalFileName: string;
    originalPath: string;
    sidecarPath: string | null;
    thumbhash: Buffer<ArrayBufferLike> | null;
    stackId: string | null;
    exifInfo?: import("src/database").Exif | null | undefined;
    faces?: {
        id: string;
        assetId: string;
        imageHeight: number;
        imageWidth: number;
        boundingBoxX1: number;
        boundingBoxX2: number;
        boundingBoxY1: number;
        boundingBoxY2: number;
        sourceType: import("src/enum").SourceType;
        personId: string | null;
        deletedAt: Date | null;
    }[] | undefined;
    library?: {
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        exclusionPatterns: string[];
        importPaths: string[];
        refreshedAt: Date | null;
    } | null | undefined;
    owner?: {
        name: string;
        id: string;
        email: string;
        profileImagePath: string;
        profileChangedAt: Date;
    } | null | undefined;
    smartSearch?: {
        assetId: string;
        embedding: string;
    } | null | undefined;
    stack?: import("src/database").Stack | null | undefined;
    files?: {
        id: string;
        path: string;
        type: AssetFileType;
    }[] | undefined;
    tags?: {
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    }[] | undefined;
} | null>;
export declare const onAfterUnlink: ({ asset: assetRepository, event: eventRepository }: AssetHookRepositories, { userId, livePhotoVideoId }: {
    userId: string;
    livePhotoVideoId: string;
}) => Promise<void>;
export declare function mapToUploadFile(file: ImmichFile): UploadFile;
export declare const asRequest: (request: AuthRequest, file: Express.Multer.File) => {
    auth: AuthDto | null;
    fieldName: UploadFieldName;
    file: UploadFile;
};
