import { AuthDto } from 'src/dtos/auth.dto';
import { Permission } from 'src/enum';
import { AccessRepository } from 'src/repositories/access.repository';
export type GrantedRequest = {
    requested: Permission[];
    current: Permission[];
};
export declare const isGranted: ({ requested, current }: GrantedRequest) => boolean;
export type AccessRequest = {
    auth: AuthDto;
    permission: Permission;
    ids: Set<string> | string[];
};
export declare const requireUploadAccess: (auth: AuthDto | null) => AuthDto;
export declare const requireAccess: (access: AccessRepository, request: AccessRequest) => Promise<void>;
export declare const checkAccess: (access: AccessRepository, { ids, auth, permission }: AccessRequest) => Promise<Set<string>>;
