"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asTriggerDrop = exports.asTriggerCreate = exports.transformTriggers = void 0;
const transformTriggers = (item) => {
    switch (item.type) {
        case 'trigger.create': {
            return (0, exports.asTriggerCreate)(item.trigger);
        }
        case 'trigger.drop': {
            return (0, exports.asTriggerDrop)(item.tableName, item.triggerName);
        }
        default: {
            return false;
        }
    }
};
exports.transformTriggers = transformTriggers;
const asTriggerCreate = (trigger) => {
    const sql = [
        `CREATE OR REPLACE TRIGGER "${trigger.name}"`,
        `${trigger.timing.toUpperCase()} ${trigger.actions.map((action) => action.toUpperCase()).join(' OR ')} ON "${trigger.tableName}"`,
    ];
    if (trigger.referencingOldTableAs || trigger.referencingNewTableAs) {
        let statement = `REFERENCING`;
        if (trigger.referencingOldTableAs) {
            statement += ` OLD TABLE AS "${trigger.referencingOldTableAs}"`;
        }
        if (trigger.referencingNewTableAs) {
            statement += ` NEW TABLE AS "${trigger.referencingNewTableAs}"`;
        }
        sql.push(statement);
    }
    if (trigger.scope) {
        sql.push(`FOR EACH ${trigger.scope.toUpperCase()}`);
    }
    if (trigger.when) {
        sql.push(`WHEN (${trigger.when})`);
    }
    sql.push(`EXECUTE FUNCTION ${trigger.functionName}();`);
    return sql.join('\n  ');
};
exports.asTriggerCreate = asTriggerCreate;
const asTriggerDrop = (tableName, triggerName) => {
    return `DROP TRIGGER "${triggerName}" ON "${tableName}";`;
};
exports.asTriggerDrop = asTriggerDrop;
//# sourceMappingURL=trigger.transformer.js.map