"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformTables = void 0;
const helpers_1 = require("../../helpers");
const column_transformer_1 = require("./column.transformer");
const transformTables = (item) => {
    switch (item.type) {
        case 'table.create': {
            return asTableCreate(item.table);
        }
        case 'table.drop': {
            return asTableDrop(item.tableName);
        }
        default: {
            return false;
        }
    }
};
exports.transformTables = transformTables;
const asTableCreate = (table) => {
    const tableName = table.name;
    const columnsTypes = table.columns
        .map((column) => `"${column.name}" ${(0, helpers_1.getColumnType)(column)}` + (0, helpers_1.getColumnModifiers)(column))
        .join(', ');
    const items = [`CREATE TABLE "${tableName}" (${columnsTypes});`];
    for (const column of table.columns) {
        if (column.comment) {
            items.push((0, helpers_1.asColumnComment)(tableName, column.name, column.comment));
        }
        if (column.storage) {
            items.push(...(0, column_transformer_1.asColumnAlter)(tableName, column.name, { storage: column.storage }));
        }
    }
    return items;
};
const asTableDrop = (tableName) => {
    return `DROP TABLE "${tableName}";`;
};
//# sourceMappingURL=table.transformer.js.map