"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformParameters = void 0;
const transformParameters = (item) => {
    switch (item.type) {
        case 'parameter.set': {
            return asParameterSet(item.parameter);
        }
        case 'parameter.reset': {
            return asParameterReset(item.databaseName, item.parameterName);
        }
        default: {
            return false;
        }
    }
};
exports.transformParameters = transformParameters;
const asParameterSet = (parameter) => {
    let sql = '';
    if (parameter.scope === 'database') {
        sql += `ALTER DATABASE "${parameter.databaseName}" `;
    }
    sql += `SET ${parameter.name} TO ${parameter.value}`;
    return sql;
};
const asParameterReset = (databaseName, parameterName) => {
    return `ALTER DATABASE "${databaseName}" RESET "${parameterName}"`;
};
//# sourceMappingURL=parameter.transformer.js.map