"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asIndexDrop = exports.asIndexCreate = exports.transformIndexes = void 0;
const helpers_1 = require("../../helpers");
const transformIndexes = (item) => {
    switch (item.type) {
        case 'index.create': {
            return (0, exports.asIndexCreate)(item.index);
        }
        case 'index.drop': {
            return (0, exports.asIndexDrop)(item.indexName);
        }
        default: {
            return false;
        }
    }
};
exports.transformIndexes = transformIndexes;
const asIndexCreate = (index) => {
    let sql = `CREATE`;
    if (index.unique) {
        sql += ' UNIQUE';
    }
    sql += ` INDEX "${index.name}" ON "${index.tableName}"`;
    if (index.columnNames) {
        const columnNames = (0, helpers_1.asColumnList)(index.columnNames);
        sql += ` (${columnNames})`;
    }
    if (index.using && index.using !== 'btree') {
        sql += ` USING ${index.using}`;
    }
    if (index.expression) {
        sql += ` (${index.expression})`;
    }
    if (index.with) {
        sql += ` WITH (${index.with})`;
    }
    if (index.where) {
        sql += ` WHERE ${index.where}`;
    }
    return sql;
};
exports.asIndexCreate = asIndexCreate;
const asIndexDrop = (indexName) => {
    return `DROP INDEX "${indexName}";`;
};
exports.asIndexDrop = asIndexDrop;
//# sourceMappingURL=index.transformer.js.map