"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformFunctions = void 0;
const transformFunctions = (item) => {
    switch (item.type) {
        case 'function.create': {
            return asFunctionCreate(item.function);
        }
        case 'function.drop': {
            return asFunctionDrop(item.functionName);
        }
        default: {
            return false;
        }
    }
};
exports.transformFunctions = transformFunctions;
const asFunctionCreate = (func) => {
    return func.expression;
};
const asFunctionDrop = (functionName) => {
    return `DROP FUNCTION ${functionName};`;
};
//# sourceMappingURL=function.transformer.js.map