"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformExtensions = void 0;
const transformExtensions = (item) => {
    switch (item.type) {
        case 'extension.create': {
            return asExtensionCreate(item.extension);
        }
        case 'extension.drop': {
            return asExtensionDrop(item.extensionName);
        }
        default: {
            return false;
        }
    }
};
exports.transformExtensions = transformExtensions;
const asExtensionCreate = (extension) => {
    return `CREATE EXTENSION IF NOT EXISTS "${extension.name}";`;
};
const asExtensionDrop = (extensionName) => {
    return `DROP EXTENSION "${extensionName}";`;
};
//# sourceMappingURL=extension.transformer.js.map