"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asConstraintDrop = exports.asConstraintAdd = exports.transformConstraints = void 0;
const helpers_1 = require("../../helpers");
const types_1 = require("../../types");
const transformConstraints = (item) => {
    switch (item.type) {
        case 'constraint.add': {
            return (0, exports.asConstraintAdd)(item.constraint);
        }
        case 'constraint.drop': {
            return (0, exports.asConstraintDrop)(item.tableName, item.constraintName);
        }
        default: {
            return false;
        }
    }
};
exports.transformConstraints = transformConstraints;
const withAction = (constraint) => ` ON UPDATE ${constraint.onUpdate ?? types_1.DatabaseActionType.NO_ACTION} ON DELETE ${constraint.onDelete ?? types_1.DatabaseActionType.NO_ACTION}`;
const asConstraintAdd = (constraint) => {
    const base = `ALTER TABLE "${constraint.tableName}" ADD CONSTRAINT "${constraint.name}"`;
    switch (constraint.type) {
        case types_1.DatabaseConstraintType.PRIMARY_KEY: {
            const columnNames = (0, helpers_1.asColumnList)(constraint.columnNames);
            return `${base} PRIMARY KEY (${columnNames});`;
        }
        case types_1.DatabaseConstraintType.FOREIGN_KEY: {
            const columnNames = (0, helpers_1.asColumnList)(constraint.columnNames);
            const referenceColumnNames = (0, helpers_1.asColumnList)(constraint.referenceColumnNames);
            return (`${base} FOREIGN KEY (${columnNames}) REFERENCES "${constraint.referenceTableName}" (${referenceColumnNames})` +
                withAction(constraint) +
                ';');
        }
        case types_1.DatabaseConstraintType.UNIQUE: {
            const columnNames = (0, helpers_1.asColumnList)(constraint.columnNames);
            return `${base} UNIQUE (${columnNames});`;
        }
        case types_1.DatabaseConstraintType.CHECK: {
            return `${base} CHECK (${constraint.expression});`;
        }
        default: {
            return [];
        }
    }
};
exports.asConstraintAdd = asConstraintAdd;
const asConstraintDrop = (tableName, constraintName) => {
    return `ALTER TABLE "${tableName}" DROP CONSTRAINT "${constraintName}";`;
};
exports.asConstraintDrop = asConstraintDrop;
//# sourceMappingURL=constraint.transformer.js.map