"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asColumnAlter = exports.transformColumns = void 0;
const helpers_1 = require("../../helpers");
const transformColumns = (item) => {
    switch (item.type) {
        case 'column.add': {
            return asColumnAdd(item.column);
        }
        case 'column.alter': {
            return (0, exports.asColumnAlter)(item.tableName, item.columnName, item.changes);
        }
        case 'column.drop': {
            return asColumnDrop(item.tableName, item.columnName);
        }
        default: {
            return false;
        }
    }
};
exports.transformColumns = transformColumns;
const asColumnAdd = (column) => {
    return (`ALTER TABLE "${column.tableName}" ADD "${column.name}" ${(0, helpers_1.getColumnType)(column)}` + (0, helpers_1.getColumnModifiers)(column) + ';');
};
const asColumnDrop = (tableName, columnName) => {
    return `ALTER TABLE "${tableName}" DROP COLUMN "${columnName}";`;
};
const asColumnAlter = (tableName, columnName, changes) => {
    const base = `ALTER TABLE "${tableName}" ALTER COLUMN "${columnName}"`;
    const items = [];
    if (changes.nullable !== undefined) {
        items.push(changes.nullable ? `${base} DROP NOT NULL;` : `${base} SET NOT NULL;`);
    }
    if (changes.default !== undefined) {
        items.push(`${base} SET DEFAULT ${changes.default};`);
    }
    if (changes.storage !== undefined) {
        items.push(`${base} SET STORAGE ${changes.storage.toUpperCase()};`);
    }
    if (changes.comment !== undefined) {
        items.push((0, helpers_1.asColumnComment)(tableName, columnName, changes.comment));
    }
    return items;
};
exports.asColumnAlter = asColumnAlter;
//# sourceMappingURL=column.transformer.js.map