"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schemaDiffToSql = void 0;
const column_transformer_1 = require("./transformers/column.transformer");
const constraint_transformer_1 = require("./transformers/constraint.transformer");
const enum_transformer_1 = require("./transformers/enum.transformer");
const extension_transformer_1 = require("./transformers/extension.transformer");
const function_transformer_1 = require("./transformers/function.transformer");
const index_transformer_1 = require("./transformers/index.transformer");
const parameter_transformer_1 = require("./transformers/parameter.transformer");
const table_transformer_1 = require("./transformers/table.transformer");
const trigger_transformer_1 = require("./transformers/trigger.transformer");
const schemaDiffToSql = (items, options = {}) => {
    return items.flatMap((item) => asSql(item).map((result) => result + withComments(options.comments, item)));
};
exports.schemaDiffToSql = schemaDiffToSql;
const transformers = [
    column_transformer_1.transformColumns,
    constraint_transformer_1.transformConstraints,
    enum_transformer_1.transformEnums,
    extension_transformer_1.transformExtensions,
    function_transformer_1.transformFunctions,
    index_transformer_1.transformIndexes,
    parameter_transformer_1.transformParameters,
    table_transformer_1.transformTables,
    trigger_transformer_1.transformTriggers,
];
const asSql = (item) => {
    for (const transform of transformers) {
        const result = transform(item);
        if (!result) {
            continue;
        }
        return asArray(result);
    }
    throw new Error(`Unhandled schema diff type: ${item.type}`);
};
const withComments = (comments, item) => {
    if (!comments) {
        return '';
    }
    return ` -- ${item.reason}`;
};
const asArray = (items) => {
    if (Array.isArray(items)) {
        return items;
    }
    return [items];
};
//# sourceMappingURL=index.js.map