import { ColumnValue } from 'src/sql-tools/from-code/decorators/column.decorator';
import { Comparer, DatabaseColumn, DiffOptions, SchemaDiff, TriggerAction, TriggerScope, TriggerTiming } from 'src/sql-tools/types';
export declare const asMetadataKey: (name: string) => string;
export declare const asSnakeCase: (name: string) => string;
export declare const asKey: (prefix: string, tableName: string, values: string[]) => string;
export declare const asOptions: <T extends {
    name?: string;
}>(options: string | T) => T;
export declare const sha1: (value: string) => string;
export declare const hasMask: (input: number, mask: number) => boolean;
export declare const parseTriggerType: (type: number) => {
    actions: TriggerAction[];
    timing: TriggerTiming;
    scope: TriggerScope;
};
export declare const fromColumnValue: (columnValue?: ColumnValue) => string | null | undefined;
export declare const setIsEqual: (source: Set<unknown>, target: Set<unknown>) => boolean;
export declare const haveEqualColumns: (sourceColumns?: string[], targetColumns?: string[]) => boolean;
export declare const compare: <T extends {
    name: string;
    synchronize: boolean;
}>(sources: T[], targets: T[], options: DiffOptions | undefined, comparer: Comparer<T>) => SchemaDiff[];
export declare const isDefaultEqual: (source: DatabaseColumn, target: DatabaseColumn) => boolean;
export declare const getColumnType: (column: DatabaseColumn) => string;
export declare const getColumnModifiers: (column: DatabaseColumn) => string;
export declare const asColumnComment: (tableName: string, columnName: string, comment: string) => string;
export declare const asColumnList: (columns: string[]) => string;
