"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processUniqueConstraints = void 0;
const column_processor_1 = require("./column.processor");
const table_processor_1 = require("./table.processor");
const helpers_1 = require("../../helpers");
const types_1 = require("../../types");
const processUniqueConstraints = (builder, items) => {
    for (const { item: { object, options }, } of items.filter((item) => item.type === 'uniqueConstraint')) {
        const table = (0, table_processor_1.resolveTable)(builder, object);
        if (!table) {
            (0, table_processor_1.onMissingTable)(builder, '@Unique', object);
            continue;
        }
        const tableName = table.name;
        const columnNames = options.columns;
        table.constraints.push({
            type: types_1.DatabaseConstraintType.UNIQUE,
            name: options.name || asUniqueConstraintName(tableName, columnNames),
            tableName,
            columnNames,
            synchronize: options.synchronize ?? true,
        });
    }
    for (const { type, item: { object, propertyName, options }, } of items.filter((item) => item.type === 'column' || item.type === 'foreignKeyColumn')) {
        const { table, column } = (0, column_processor_1.resolveColumn)(builder, object, propertyName);
        if (!table) {
            (0, table_processor_1.onMissingTable)(builder, '@Column', object);
            continue;
        }
        if (!column) {
            (0, column_processor_1.onMissingColumn)(builder, '@Column', object, propertyName);
            continue;
        }
        if (type === 'column' && !options.primary && (options.unique || options.uniqueConstraintName)) {
            table.constraints.push({
                type: types_1.DatabaseConstraintType.UNIQUE,
                name: options.uniqueConstraintName || asUniqueConstraintName(table.name, [column.name]),
                tableName: table.name,
                columnNames: [column.name],
                synchronize: options.synchronize ?? true,
            });
        }
    }
};
exports.processUniqueConstraints = processUniqueConstraints;
const asUniqueConstraintName = (table, columns) => (0, helpers_1.asKey)('UQ_', table, columns);
//# sourceMappingURL=unique-constraint.processor.js.map