"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processTriggers = void 0;
const table_processor_1 = require("./table.processor");
const helpers_1 = require("../../helpers");
const processTriggers = (builder, items) => {
    for (const { item: { object, options }, } of items.filter((item) => item.type === 'trigger')) {
        const table = (0, table_processor_1.resolveTable)(builder, object);
        if (!table) {
            (0, table_processor_1.onMissingTable)(builder, '@Trigger', object);
            continue;
        }
        table.triggers.push({
            name: options.name || asTriggerName(table.name, options),
            tableName: table.name,
            timing: options.timing,
            actions: options.actions,
            when: options.when,
            scope: options.scope,
            referencingNewTableAs: options.referencingNewTableAs,
            referencingOldTableAs: options.referencingOldTableAs,
            functionName: options.functionName,
            synchronize: options.synchronize ?? true,
        });
    }
};
exports.processTriggers = processTriggers;
const asTriggerName = (table, trigger) => (0, helpers_1.asKey)('TR_', table, [...trigger.actions, trigger.scope, trigger.timing, trigger.functionName]);
//# sourceMappingURL=trigger.processor.js.map