"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.onMissingTable = exports.resolveTable = exports.processTables = void 0;
const helpers_1 = require("../../helpers");
const processTables = (builder, items) => {
    for (const { item: { options, object }, } of items.filter((item) => item.type === 'table')) {
        const test = readMetadata(object);
        if (test) {
            throw new Error(`Table ${test.name} has already been registered. Does ${object.name} have two @Table() decorators?`);
        }
        const tableName = options.name || (0, helpers_1.asSnakeCase)(object.name);
        writeMetadata(object, { name: tableName, options });
        builder.tables.push({
            name: tableName,
            columns: [],
            constraints: [],
            indexes: [],
            triggers: [],
            synchronize: options.synchronize ?? true,
            metadata: { options, object },
        });
    }
};
exports.processTables = processTables;
const resolveTable = (builder, object) => {
    const metadata = readMetadata(object);
    if (!metadata) {
        return;
    }
    return builder.tables.find((table) => table.name === metadata.name);
};
exports.resolveTable = resolveTable;
const onMissingTable = (builder, context, object, propertyName) => {
    const label = object.constructor.name + (propertyName ? '.' + String(propertyName) : '');
    builder.warnings.push(`[${context}] Unable to find table (${label})`);
};
exports.onMissingTable = onMissingTable;
const METADATA_KEY = (0, helpers_1.asMetadataKey)('table-metadata');
const readMetadata = (object) => Reflect.getMetadata(METADATA_KEY, object);
const writeMetadata = (object, metadata) => Reflect.defineMetadata(METADATA_KEY, metadata, object);
//# sourceMappingURL=table.processor.js.map