"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processPrimaryKeyConstraints = void 0;
const helpers_1 = require("../../helpers");
const types_1 = require("../../types");
const processPrimaryKeyConstraints = (builder) => {
    for (const table of builder.tables) {
        const columnNames = [];
        for (const column of table.columns) {
            if (column.primary) {
                columnNames.push(column.name);
            }
        }
        if (columnNames.length > 0) {
            table.constraints.push({
                type: types_1.DatabaseConstraintType.PRIMARY_KEY,
                name: table.metadata.options.primaryConstraintName || asPrimaryKeyConstraintName(table.name, columnNames),
                tableName: table.name,
                columnNames,
                synchronize: table.metadata.options.synchronize ?? true,
            });
        }
    }
};
exports.processPrimaryKeyConstraints = processPrimaryKeyConstraints;
const asPrimaryKeyConstraintName = (table, columns) => (0, helpers_1.asKey)('PK_', table, columns);
//# sourceMappingURL=primary-key-contraint.processor.js.map