"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processIndexes = void 0;
const column_processor_1 = require("./column.processor");
const table_processor_1 = require("./table.processor");
const helpers_1 = require("../../helpers");
const processIndexes = (builder, items, config) => {
    for (const { item: { object, options }, } of items.filter((item) => item.type === 'index')) {
        const table = (0, table_processor_1.resolveTable)(builder, object);
        if (!table) {
            (0, table_processor_1.onMissingTable)(builder, '@Check', object);
            continue;
        }
        table.indexes.push({
            name: options.name || asIndexName(table.name, options.columns, options.where),
            tableName: table.name,
            unique: options.unique ?? false,
            expression: options.expression,
            using: options.using,
            with: options.with,
            where: options.where,
            columnNames: options.columns,
            synchronize: options.synchronize ?? true,
        });
    }
    for (const { type, item: { object, propertyName, options }, } of items.filter((item) => item.type === 'column' || item.type === 'foreignKeyColumn')) {
        const { table, column } = (0, column_processor_1.resolveColumn)(builder, object, propertyName);
        if (!table) {
            (0, table_processor_1.onMissingTable)(builder, '@Column', object);
            continue;
        }
        if (!column) {
            (0, column_processor_1.onMissingColumn)(builder, '@Column', object, propertyName);
            continue;
        }
        if (options.index === false) {
            continue;
        }
        const isIndexRequested = options.indexName || options.index || (type === 'foreignKeyColumn' && config.createForeignKeyIndexes);
        if (!isIndexRequested) {
            continue;
        }
        const indexName = options.indexName || asIndexName(table.name, [column.name]);
        const isIndexPresent = table.indexes.some((index) => index.name === indexName);
        if (isIndexPresent) {
            continue;
        }
        const isOnlyPrimaryColumn = options.primary && table.columns.filter(({ primary }) => primary === true).length === 1;
        if (isOnlyPrimaryColumn) {
            continue;
        }
        table.indexes.push({
            name: indexName,
            tableName: table.name,
            unique: false,
            columnNames: [column.name],
            synchronize: options.synchronize ?? true,
        });
    }
};
exports.processIndexes = processIndexes;
const asIndexName = (table, columns, where) => {
    const items = [];
    for (const columnName of columns ?? []) {
        items.push(columnName);
    }
    if (where) {
        items.push(where);
    }
    return (0, helpers_1.asKey)('IDX_', table, items);
};
//# sourceMappingURL=index.processor.js.map