"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processConfigurationParameters = void 0;
const helpers_1 = require("../../helpers");
const processConfigurationParameters = (builder, items) => {
    for (const { item: { options }, } of items.filter((item) => item.type === 'configurationParameter')) {
        builder.parameters.push({
            databaseName: builder.name,
            name: options.name,
            value: (0, helpers_1.fromColumnValue)(options.value),
            scope: options.scope,
            synchronize: options.synchronize ?? true,
        });
    }
};
exports.processConfigurationParameters = processConfigurationParameters;
//# sourceMappingURL=configuration-parameter.processor.js.map