"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processCheckConstraints = void 0;
const table_processor_1 = require("./table.processor");
const helpers_1 = require("../../helpers");
const types_1 = require("../../types");
const processCheckConstraints = (builder, items) => {
    for (const { item: { object, options }, } of items.filter((item) => item.type === 'checkConstraint')) {
        const table = (0, table_processor_1.resolveTable)(builder, object);
        if (!table) {
            (0, table_processor_1.onMissingTable)(builder, '@Check', object);
            continue;
        }
        const tableName = table.name;
        table.constraints.push({
            type: types_1.DatabaseConstraintType.CHECK,
            name: options.name || asCheckConstraintName(tableName, options.expression),
            tableName,
            expression: options.expression,
            synchronize: options.synchronize ?? true,
        });
    }
};
exports.processCheckConstraints = processCheckConstraints;
const asCheckConstraintName = (table, expression) => (0, helpers_1.asKey)('CHK_', table, [expression]);
//# sourceMappingURL=check-constraint.processor.js.map