"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schemaFromCode = exports.reset = void 0;
require("reflect-metadata");
const check_constraint_processor_1 = require("./processors/check-constraint.processor");
const column_processor_1 = require("./processors/column.processor");
const configuration_parameter_processor_1 = require("./processors/configuration-parameter.processor");
const database_processor_1 = require("./processors/database.processor");
const enum_processor_1 = require("./processors/enum.processor");
const extension_processor_1 = require("./processors/extension.processor");
const foreign_key_constriant_processor_1 = require("./processors/foreign-key-constriant.processor");
const function_processor_1 = require("./processors/function.processor");
const index_processor_1 = require("./processors/index.processor");
const primary_key_contraint_processor_1 = require("./processors/primary-key-contraint.processor");
const table_processor_1 = require("./processors/table.processor");
const trigger_processor_1 = require("./processors/trigger.processor");
const unique_constraint_processor_1 = require("./processors/unique-constraint.processor");
const register_1 = require("./register");
let initialized = false;
let schema;
const reset = () => {
    initialized = false;
    (0, register_1.resetRegisteredItems)();
};
exports.reset = reset;
const processors = [
    database_processor_1.processDatabases,
    configuration_parameter_processor_1.processConfigurationParameters,
    enum_processor_1.processEnums,
    extension_processor_1.processExtensions,
    function_processor_1.processFunctions,
    table_processor_1.processTables,
    column_processor_1.processColumns,
    unique_constraint_processor_1.processUniqueConstraints,
    check_constraint_processor_1.processCheckConstraints,
    primary_key_contraint_processor_1.processPrimaryKeyConstraints,
    foreign_key_constriant_processor_1.processForeignKeyConstraints,
    index_processor_1.processIndexes,
    trigger_processor_1.processTriggers,
];
const schemaFromCode = (options = {}) => {
    if (!initialized) {
        const globalOptions = {
            createForeignKeyIndexes: options.createForeignKeyIndexes ?? true,
        };
        const builder = {
            name: 'postgres',
            schemaName: 'public',
            tables: [],
            functions: [],
            enums: [],
            extensions: [],
            parameters: [],
            warnings: [],
        };
        const items = (0, register_1.getRegisteredItems)();
        for (const processor of processors) {
            processor(builder, items, globalOptions);
        }
        schema = { ...builder, tables: builder.tables.map(({ metadata: _, ...table }) => table) };
        initialized = true;
    }
    return schema;
};
exports.schemaFromCode = schemaFromCode;
//# sourceMappingURL=index.js.map