"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schemaDiff = void 0;
const enum_comparer_1 = require("./comparers/enum.comparer");
const extension_comparer_1 = require("./comparers/extension.comparer");
const function_comparer_1 = require("./comparers/function.comparer");
const parameter_comparer_1 = require("./comparers/parameter.comparer");
const table_comparer_1 = require("./comparers/table.comparer");
const helpers_1 = require("../helpers");
const to_sql_1 = require("../to-sql");
const types_1 = require("../types");
const schemaDiff = (source, target, options = {}) => {
    const items = [
        ...(0, helpers_1.compare)(source.parameters, target.parameters, options.parameters, parameter_comparer_1.compareParameters),
        ...(0, helpers_1.compare)(source.extensions, target.extensions, options.extension, extension_comparer_1.compareExtensions),
        ...(0, helpers_1.compare)(source.functions, target.functions, options.functions, function_comparer_1.compareFunctions),
        ...(0, helpers_1.compare)(source.enums, target.enums, options.enums, enum_comparer_1.compareEnums),
        ...(0, helpers_1.compare)(source.tables, target.tables, options.tables, table_comparer_1.compareTables),
    ];
    const itemMap = {
        'enum.create': [],
        'enum.drop': [],
        'extension.create': [],
        'extension.drop': [],
        'function.create': [],
        'function.drop': [],
        'table.create': [],
        'table.drop': [],
        'column.add': [],
        'column.alter': [],
        'column.drop': [],
        'constraint.add': [],
        'constraint.drop': [],
        'index.create': [],
        'index.drop': [],
        'trigger.create': [],
        'trigger.drop': [],
        'parameter.set': [],
        'parameter.reset': [],
    };
    for (const item of items) {
        itemMap[item.type].push(item);
    }
    const constraintAdds = itemMap['constraint.add'].filter((item) => item.type === 'constraint.add');
    const orderedItems = [
        ...itemMap['extension.create'],
        ...itemMap['function.create'],
        ...itemMap['parameter.set'],
        ...itemMap['parameter.reset'],
        ...itemMap['enum.create'],
        ...itemMap['trigger.drop'],
        ...itemMap['index.drop'],
        ...itemMap['constraint.drop'],
        ...itemMap['table.create'],
        ...itemMap['column.alter'],
        ...itemMap['column.add'],
        ...constraintAdds.filter(({ constraint }) => constraint.type === types_1.DatabaseConstraintType.PRIMARY_KEY),
        ...constraintAdds.filter(({ constraint }) => constraint.type === types_1.DatabaseConstraintType.FOREIGN_KEY),
        ...constraintAdds.filter(({ constraint }) => constraint.type === types_1.DatabaseConstraintType.UNIQUE),
        ...constraintAdds.filter(({ constraint }) => constraint.type === types_1.DatabaseConstraintType.CHECK),
        ...itemMap['index.create'],
        ...itemMap['trigger.create'],
        ...itemMap['column.drop'],
        ...itemMap['table.drop'],
        ...itemMap['enum.drop'],
        ...itemMap['function.drop'],
    ];
    return {
        items: orderedItems,
        asSql: (options) => (0, to_sql_1.schemaDiffToSql)(orderedItems, options),
    };
};
exports.schemaDiff = schemaDiff;
//# sourceMappingURL=index.js.map