"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareTables = void 0;
const column_comparer_1 = require("./column.comparer");
const constraint_comparer_1 = require("./constraint.comparer");
const index_comparer_1 = require("./index.comparer");
const trigger_comparer_1 = require("./trigger.comparer");
const helpers_1 = require("../../helpers");
const types_1 = require("../../types");
exports.compareTables = {
    onMissing: (source) => [
        {
            type: 'table.create',
            table: source,
            reason: types_1.Reason.MissingInTarget,
        },
        ...compareTable(source, {
            name: source.name,
            columns: [],
            indexes: [],
            constraints: [],
            triggers: [],
            synchronize: true,
        }, { columns: false }),
    ],
    onExtra: (target) => [
        ...compareTable({
            name: target.name,
            columns: [],
            indexes: [],
            constraints: [],
            triggers: [],
            synchronize: true,
        }, target, { columns: false }),
        {
            type: 'table.drop',
            tableName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: (source, target) => compareTable(source, target, { columns: true }),
};
const compareTable = (source, target, options) => {
    return [
        ...(options.columns ? (0, helpers_1.compare)(source.columns, target.columns, {}, column_comparer_1.compareColumns) : []),
        ...(0, helpers_1.compare)(source.indexes, target.indexes, {}, index_comparer_1.compareIndexes),
        ...(0, helpers_1.compare)(source.constraints, target.constraints, {}, constraint_comparer_1.compareConstraints),
        ...(0, helpers_1.compare)(source.triggers, target.triggers, {}, trigger_comparer_1.compareTriggers),
    ];
};
//# sourceMappingURL=table.comparer.js.map