"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareFunctions = void 0;
const types_1 = require("../../types");
exports.compareFunctions = {
    onMissing: (source) => [
        {
            type: 'function.create',
            function: source,
            reason: types_1.Reason.MissingInTarget,
        },
    ],
    onExtra: (target) => [
        {
            type: 'function.drop',
            functionName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: (source, target) => {
        if (source.expression !== target.expression) {
            const reason = `function expression has changed (${source.expression} vs ${target.expression})`;
            return [
                {
                    type: 'function.create',
                    function: source,
                    reason,
                },
            ];
        }
        return [];
    },
};
//# sourceMappingURL=function.comparer.js.map