"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareEnums = void 0;
const types_1 = require("../../types");
exports.compareEnums = {
    onMissing: (source) => [
        {
            type: 'enum.create',
            enum: source,
            reason: types_1.Reason.MissingInTarget,
        },
    ],
    onExtra: (target) => [
        {
            type: 'enum.drop',
            enumName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: (source, target) => {
        if (source.values.toString() !== target.values.toString()) {
            const reason = `enum values has changed (${source.values} vs ${target.values})`;
            return [
                {
                    type: 'enum.drop',
                    enumName: source.name,
                    reason,
                },
                {
                    type: 'enum.create',
                    enum: source,
                    reason,
                },
            ];
        }
        return [];
    },
};
//# sourceMappingURL=enum.comparer.js.map