"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareColumns = void 0;
const helpers_1 = require("../../helpers");
const types_1 = require("../../types");
exports.compareColumns = {
    onMissing: (source) => [
        {
            type: 'column.add',
            column: source,
            reason: types_1.Reason.MissingInTarget,
        },
    ],
    onExtra: (target) => [
        {
            type: 'column.drop',
            tableName: target.tableName,
            columnName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: (source, target) => {
        const sourceType = (0, helpers_1.getColumnType)(source);
        const targetType = (0, helpers_1.getColumnType)(target);
        const isTypeChanged = sourceType !== targetType;
        if (isTypeChanged) {
            return dropAndRecreateColumn(source, target, `column type is different (${sourceType} vs ${targetType})`);
        }
        const items = [];
        if (source.nullable !== target.nullable) {
            items.push({
                type: 'column.alter',
                tableName: source.tableName,
                columnName: source.name,
                changes: {
                    nullable: source.nullable,
                },
                reason: `nullable is different (${source.nullable} vs ${target.nullable})`,
            });
        }
        if (!(0, helpers_1.isDefaultEqual)(source, target)) {
            items.push({
                type: 'column.alter',
                tableName: source.tableName,
                columnName: source.name,
                changes: {
                    default: String(source.default),
                },
                reason: `default is different (${source.default} vs ${target.default})`,
            });
        }
        if (source.comment !== target.comment) {
            items.push({
                type: 'column.alter',
                tableName: source.tableName,
                columnName: source.name,
                changes: {
                    comment: String(source.comment),
                },
                reason: `comment is different (${source.comment} vs ${target.comment})`,
            });
        }
        return items;
    },
};
const dropAndRecreateColumn = (source, target, reason) => {
    return [
        {
            type: 'column.drop',
            tableName: target.tableName,
            columnName: target.name,
            reason,
        },
        { type: 'column.add', column: source, reason },
    ];
};
//# sourceMappingURL=column.comparer.js.map