"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VersionService = void 0;
const common_1 = require("@nestjs/common");
const luxon_1 = require("luxon");
const semver_1 = __importStar(require("semver"));
const constants_1 = require("../constants");
const decorators_1 = require("../decorators");
const server_dto_1 = require("../dtos/server.dto");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
const asNotification = ({ checkedAt, releaseVersion }) => {
    return {
        isAvailable: semver_1.default.gt(releaseVersion, constants_1.serverVersion),
        checkedAt,
        serverVersion: server_dto_1.ServerVersionResponseDto.fromSemVer(constants_1.serverVersion),
        releaseVersion: server_dto_1.ServerVersionResponseDto.fromSemVer(new semver_1.SemVer(releaseVersion)),
    };
};
let VersionService = class VersionService extends base_service_1.BaseService {
    async onBootstrap() {
        await this.handleVersionCheck();
        await this.databaseRepository.withLock(enum_1.DatabaseLock.VersionHistory, async () => {
            const previous = await this.versionRepository.getLatest();
            const current = constants_1.serverVersion.toString();
            if (!previous) {
                await this.versionRepository.create({ version: current });
                return;
            }
            if (previous.version !== current) {
                const previousVersion = new semver_1.SemVer(previous.version);
                this.logger.log(`Adding ${current} to upgrade history`);
                await this.versionRepository.create({ version: current });
                const needsNewMemories = semver_1.default.lt(previousVersion, '1.129.0');
                if (needsNewMemories) {
                    await this.jobRepository.queue({ name: enum_1.JobName.MEMORIES_CREATE });
                }
            }
        });
    }
    getVersion() {
        return server_dto_1.ServerVersionResponseDto.fromSemVer(constants_1.serverVersion);
    }
    getVersionHistory() {
        return this.versionRepository.getAll();
    }
    async handleQueueVersionCheck() {
        await this.jobRepository.queue({ name: enum_1.JobName.VERSION_CHECK, data: {} });
    }
    async handleVersionCheck() {
        try {
            this.logger.debug('Running version check');
            const { environment } = this.configRepository.getEnv();
            if (environment === enum_1.ImmichEnvironment.DEVELOPMENT) {
                return enum_1.JobStatus.SKIPPED;
            }
            const { newVersionCheck } = await this.getConfig({ withCache: true });
            if (!newVersionCheck.enabled) {
                return enum_1.JobStatus.SKIPPED;
            }
            const versionCheck = await this.systemMetadataRepository.get(enum_1.SystemMetadataKey.VERSION_CHECK_STATE);
            if (versionCheck?.checkedAt) {
                const lastUpdate = luxon_1.DateTime.fromISO(versionCheck.checkedAt);
                const elapsedTime = luxon_1.DateTime.now().diff(lastUpdate).as('minutes');
                if (elapsedTime < 60) {
                    return enum_1.JobStatus.SKIPPED;
                }
            }
            const { tag_name: releaseVersion, published_at: publishedAt } = await this.serverInfoRepository.getGitHubRelease();
            const metadata = { checkedAt: luxon_1.DateTime.utc().toISO(), releaseVersion };
            await this.systemMetadataRepository.set(enum_1.SystemMetadataKey.VERSION_CHECK_STATE, metadata);
            if (semver_1.default.gt(releaseVersion, constants_1.serverVersion)) {
                this.logger.log(`Found ${releaseVersion}, released at ${new Date(publishedAt).toLocaleString()}`);
                this.eventRepository.clientBroadcast('on_new_release', asNotification(metadata));
            }
        }
        catch (error) {
            this.logger.warn(`Unable to run version check: ${error}`, error?.stack);
            return enum_1.JobStatus.FAILED;
        }
        return enum_1.JobStatus.SUCCESS;
    }
    async onWebsocketConnection({ userId }) {
        this.eventRepository.clientSend('on_server_version', userId, constants_1.serverVersion);
        const metadata = await this.systemMetadataRepository.get(enum_1.SystemMetadataKey.VERSION_CHECK_STATE);
        if (metadata) {
            this.eventRepository.clientSend('on_new_release', userId, asNotification(metadata));
        }
    }
};
exports.VersionService = VersionService;
__decorate([
    (0, decorators_1.OnEvent)({ name: 'app.bootstrap' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], VersionService.prototype, "onBootstrap", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.VERSION_CHECK, queue: enum_1.QueueName.BACKGROUND_TASK }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], VersionService.prototype, "handleVersionCheck", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'websocket.connect' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], VersionService.prototype, "onWebsocketConnection", null);
exports.VersionService = VersionService = __decorate([
    (0, common_1.Injectable)()
], VersionService);
//# sourceMappingURL=version.service.js.map