import { JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
export declare class VersionService extends BaseService {
    onBootstrap(): Promise<void>;
    getVersion(): {
        major: number;
        minor: number;
        patch: number;
    };
    getVersionHistory(): Promise<{
        version: string;
        id: string;
        createdAt: Date;
    }[]>;
    handleQueueVersionCheck(): Promise<void>;
    handleVersionCheck(): Promise<JobStatus>;
    onWebsocketConnection({ userId }: ArgOf<'websocket.connect'>): Promise<void>;
}
