"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserAdminService = void 0;
const common_1 = require("@nestjs/common");
const constants_1 = require("../constants");
const user_preferences_dto_1 = require("../dtos/user-preferences.dto");
const user_dto_1 = require("../dtos/user.dto");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
const preferences_1 = require("../utils/preferences");
let UserAdminService = class UserAdminService extends base_service_1.BaseService {
    async search(auth, dto) {
        const users = await this.userRepository.getList({ withDeleted: dto.withDeleted });
        return users.map((user) => (0, user_dto_1.mapUserAdmin)(user));
    }
    async create(dto) {
        const { notify, ...userDto } = dto;
        const config = await this.getConfig({ withCache: false });
        if (!config.oauth.enabled && !userDto.password) {
            throw new common_1.BadRequestException('password is required');
        }
        const user = await this.createUser(userDto);
        await this.eventRepository.emit('user.signup', {
            notify: !!notify,
            id: user.id,
            tempPassword: user.shouldChangePassword ? userDto.password : undefined,
        });
        return (0, user_dto_1.mapUserAdmin)(user);
    }
    async get(auth, id) {
        const user = await this.findOrFail(id, { withDeleted: true });
        return (0, user_dto_1.mapUserAdmin)(user);
    }
    async update(auth, id, dto) {
        const user = await this.findOrFail(id, {});
        if (dto.quotaSizeInBytes && user.quotaSizeInBytes !== dto.quotaSizeInBytes) {
            await this.userRepository.syncUsage(id);
        }
        if (dto.email) {
            const duplicate = await this.userRepository.getByEmail(dto.email);
            if (duplicate && duplicate.id !== id) {
                throw new common_1.BadRequestException('Email already in use by another account');
            }
        }
        if (dto.storageLabel) {
            const duplicate = await this.userRepository.getByStorageLabel(dto.storageLabel);
            if (duplicate && duplicate.id !== id) {
                throw new common_1.BadRequestException('Storage label already in use by another account');
            }
        }
        if (dto.password) {
            dto.password = await this.cryptoRepository.hashBcrypt(dto.password, constants_1.SALT_ROUNDS);
        }
        if (dto.storageLabel === '') {
            dto.storageLabel = null;
        }
        const updatedUser = await this.userRepository.update(id, { ...dto, updatedAt: new Date() });
        return (0, user_dto_1.mapUserAdmin)(updatedUser);
    }
    async delete(auth, id, dto) {
        const { force } = dto;
        const { isAdmin } = await this.findOrFail(id, {});
        if (isAdmin) {
            throw new common_1.ForbiddenException('Cannot delete admin user');
        }
        await this.albumRepository.softDeleteAll(id);
        const status = force ? enum_1.UserStatus.REMOVING : enum_1.UserStatus.DELETED;
        const user = await this.userRepository.update(id, { status, deletedAt: new Date() });
        if (force) {
            await this.jobRepository.queue({ name: enum_1.JobName.USER_DELETION, data: { id: user.id, force } });
        }
        return (0, user_dto_1.mapUserAdmin)(user);
    }
    async restore(auth, id) {
        await this.findOrFail(id, { withDeleted: true });
        await this.albumRepository.restoreAll(id);
        const user = await this.userRepository.restore(id);
        return (0, user_dto_1.mapUserAdmin)(user);
    }
    async getPreferences(auth, id) {
        const { email } = await this.findOrFail(id, { withDeleted: true });
        const metadata = await this.userRepository.getMetadata(id);
        const preferences = (0, preferences_1.getPreferences)(email, metadata);
        return (0, user_preferences_dto_1.mapPreferences)(preferences);
    }
    async updatePreferences(auth, id, dto) {
        const { email } = await this.findOrFail(id, { withDeleted: false });
        const metadata = await this.userRepository.getMetadata(id);
        const preferences = (0, preferences_1.getPreferences)(email, metadata);
        const newPreferences = (0, preferences_1.mergePreferences)(preferences, dto);
        await this.userRepository.upsertMetadata(id, {
            key: enum_1.UserMetadataKey.PREFERENCES,
            value: (0, preferences_1.getPreferencesPartial)({ email }, newPreferences),
        });
        return (0, user_preferences_dto_1.mapPreferences)(newPreferences);
    }
    async findOrFail(id, options) {
        const user = await this.userRepository.get(id, options);
        if (!user) {
            throw new common_1.BadRequestException('User not found');
        }
        return user;
    }
};
exports.UserAdminService = UserAdminService;
exports.UserAdminService = UserAdminService = __decorate([
    (0, common_1.Injectable)()
], UserAdminService);
//# sourceMappingURL=user-admin.service.js.map