import { SystemConfigDto } from 'src/dtos/system-config.dto';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
export declare class SystemConfigService extends BaseService {
    onBootstrap(): Promise<void>;
    getSystemConfig(): Promise<SystemConfigDto>;
    getDefaults(): SystemConfigDto;
    onConfigInit({ newConfig: { logging } }: ArgOf<'config.init'>): void;
    onConfigUpdate({ newConfig }: ArgOf<'config.update'>): void;
    onConfigValidate({ newConfig, oldConfig }: ArgOf<'config.validate'>): void;
    updateSystemConfig(dto: SystemConfigDto): Promise<SystemConfigDto>;
    getCustomCss(): Promise<string>;
}
