import { Writable } from 'node:stream';
import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetDeltaSyncDto, AssetDeltaSyncResponseDto, AssetFullSyncDto, SyncAckDeleteDto, SyncAckSetDto, SyncStreamDto } from 'src/dtos/sync.dto';
import { SyncEntityType, SyncRequestType } from 'src/enum';
import { BaseService } from 'src/services/base.service';
export declare const SYNC_TYPES_ORDER: SyncRequestType[];
export declare class SyncService extends BaseService {
    getAcks(auth: AuthDto): Promise<{
        type: SyncEntityType;
        ack: string;
    }[]>;
    setAcks(auth: AuthDto, dto: SyncAckSetDto): Promise<undefined>;
    deleteAcks(auth: AuthDto, dto: SyncAckDeleteDto): Promise<undefined>;
    stream(auth: AuthDto, response: Writable, dto: SyncStreamDto): Promise<undefined>;
    getFullSync(auth: AuthDto, dto: AssetFullSyncDto): Promise<AssetResponseDto[]>;
    getDeltaSync(auth: AuthDto, dto: AssetDeltaSyncDto): Promise<AssetDeltaSyncResponseDto>;
}
