import { SystemConfigTemplateStorageOptionDto } from 'src/dtos/system-config.dto';
import { JobName, JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
import { JobOf, StorageAsset } from 'src/types';
export interface MoveAssetMetadata {
    storageLabel: string | null;
    filename: string;
}
export declare class StorageTemplateService extends BaseService {
    private _template;
    private get template();
    onConfigInit({ newConfig }: ArgOf<'config.init'>): void;
    onConfigUpdate({ newConfig }: ArgOf<'config.update'>): void;
    onConfigValidate({ newConfig }: ArgOf<'config.validate'>): void;
    getStorageTemplateOptions(): SystemConfigTemplateStorageOptionDto;
    handleMigrationSingle({ id }: JobOf<JobName.STORAGE_TEMPLATE_MIGRATION_SINGLE>): Promise<JobStatus>;
    handleMigration(): Promise<JobStatus>;
    handleMoveHistoryCleanup({ assetId }: ArgOf<'asset.delete'>): Promise<void>;
    moveAsset(asset: StorageAsset, metadata: MoveAssetMetadata): Promise<void>;
    private getTemplatePath;
    private compile;
    private render;
}
