"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackService = void 0;
const common_1 = require("@nestjs/common");
const stack_dto_1 = require("../dtos/stack.dto");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
let StackService = class StackService extends base_service_1.BaseService {
    async search(auth, dto) {
        const stacks = await this.stackRepository.search({
            ownerId: auth.user.id,
            primaryAssetId: dto.primaryAssetId,
        });
        return stacks.map((stack) => (0, stack_dto_1.mapStack)(stack, { auth }));
    }
    async create(auth, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.ASSET_UPDATE, ids: dto.assetIds });
        const stack = await this.stackRepository.create({ ownerId: auth.user.id, assetIds: dto.assetIds });
        await this.eventRepository.emit('stack.create', { stackId: stack.id, userId: auth.user.id });
        return (0, stack_dto_1.mapStack)(stack, { auth });
    }
    async get(auth, id) {
        await this.requireAccess({ auth, permission: enum_1.Permission.STACK_READ, ids: [id] });
        const stack = await this.findOrFail(id);
        return (0, stack_dto_1.mapStack)(stack, { auth });
    }
    async update(auth, id, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.STACK_UPDATE, ids: [id] });
        const stack = await this.findOrFail(id);
        if (dto.primaryAssetId && !stack.assets.some(({ id }) => id === dto.primaryAssetId)) {
            throw new common_1.BadRequestException('Primary asset must be in the stack');
        }
        const updatedStack = await this.stackRepository.update(id, { id, primaryAssetId: dto.primaryAssetId });
        await this.eventRepository.emit('stack.update', { stackId: id, userId: auth.user.id });
        return (0, stack_dto_1.mapStack)(updatedStack, { auth });
    }
    async delete(auth, id) {
        await this.requireAccess({ auth, permission: enum_1.Permission.STACK_DELETE, ids: [id] });
        await this.stackRepository.delete(id);
        await this.eventRepository.emit('stack.delete', { stackId: id, userId: auth.user.id });
    }
    async deleteAll(auth, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.STACK_DELETE, ids: dto.ids });
        await this.stackRepository.deleteAll(dto.ids);
        await this.eventRepository.emit('stacks.delete', { stackIds: dto.ids, userId: auth.user.id });
    }
    async findOrFail(id) {
        const stack = await this.stackRepository.getById(id);
        if (!stack) {
            throw new Error('Asset stack not found');
        }
        return stack;
    }
};
exports.StackService = StackService;
exports.StackService = StackService = __decorate([
    (0, common_1.Injectable)()
], StackService);
//# sourceMappingURL=stack.service.js.map