"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmartInfoService = void 0;
const common_1 = require("@nestjs/common");
const constants_1 = require("../constants");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const asset_repository_1 = require("../repositories/asset.repository");
const base_service_1 = require("./base.service");
const misc_1 = require("../utils/misc");
const pagination_1 = require("../utils/pagination");
let SmartInfoService = class SmartInfoService extends base_service_1.BaseService {
    async onConfigInit({ newConfig }) {
        await this.init(newConfig);
    }
    async onConfigUpdate({ oldConfig, newConfig }) {
        await this.init(newConfig, oldConfig);
    }
    onConfigValidate({ newConfig }) {
        try {
            (0, misc_1.getCLIPModelInfo)(newConfig.machineLearning.clip.modelName);
        }
        catch {
            throw new Error(`Unknown CLIP model: ${newConfig.machineLearning.clip.modelName}. Please check the model name for typos and confirm this is a supported model.`);
        }
    }
    async init(newConfig, oldConfig) {
        if (!(0, misc_1.isSmartSearchEnabled)(newConfig.machineLearning)) {
            return;
        }
        await this.databaseRepository.withLock(enum_1.DatabaseLock.CLIPDimSize, async () => {
            const { dimSize } = (0, misc_1.getCLIPModelInfo)(newConfig.machineLearning.clip.modelName);
            const dbDimSize = await this.searchRepository.getDimensionSize();
            this.logger.verbose(`Current database CLIP dimension size is ${dbDimSize}`);
            const modelChange = oldConfig && oldConfig.machineLearning.clip.modelName !== newConfig.machineLearning.clip.modelName;
            const dimSizeChange = dbDimSize !== dimSize;
            if (!modelChange && !dimSizeChange) {
                return;
            }
            const { isPaused } = await this.jobRepository.getQueueStatus(enum_1.QueueName.SMART_SEARCH);
            if (!isPaused) {
                await this.jobRepository.pause(enum_1.QueueName.SMART_SEARCH);
            }
            await this.jobRepository.waitForQueueCompletion(enum_1.QueueName.SMART_SEARCH);
            if (dimSizeChange) {
                this.logger.log(`Dimension size of model ${newConfig.machineLearning.clip.modelName} is ${dimSize}, but database expects ${dbDimSize}.`);
                this.logger.log(`Updating database CLIP dimension size to ${dimSize}.`);
                await this.searchRepository.setDimensionSize(dimSize);
                this.logger.log(`Successfully updated database CLIP dimension size from ${dbDimSize} to ${dimSize}.`);
            }
            else {
                await this.searchRepository.deleteAllSearchEmbeddings();
            }
            if (!isPaused) {
                await this.jobRepository.resume(enum_1.QueueName.SMART_SEARCH);
            }
        });
    }
    async handleQueueEncodeClip({ force }) {
        const { machineLearning } = await this.getConfig({ withCache: false });
        if (!(0, misc_1.isSmartSearchEnabled)(machineLearning)) {
            return enum_1.JobStatus.SKIPPED;
        }
        if (force) {
            await this.searchRepository.deleteAllSearchEmbeddings();
        }
        const assetPagination = (0, pagination_1.usePagination)(constants_1.JOBS_ASSET_PAGINATION_SIZE, (pagination) => {
            return force
                ? this.assetRepository.getAll(pagination, { isVisible: true })
                : this.assetRepository.getWithout(pagination, asset_repository_1.WithoutProperty.SMART_SEARCH);
        });
        for await (const assets of assetPagination) {
            await this.jobRepository.queueAll(assets.map((asset) => ({ name: enum_1.JobName.SMART_SEARCH, data: { id: asset.id } })));
        }
        return enum_1.JobStatus.SUCCESS;
    }
    async handleEncodeClip({ id }) {
        const { machineLearning } = await this.getConfig({ withCache: true });
        if (!(0, misc_1.isSmartSearchEnabled)(machineLearning)) {
            return enum_1.JobStatus.SKIPPED;
        }
        const asset = await this.assetJobRepository.getForClipEncoding(id);
        if (!asset || asset.files.length !== 1) {
            return enum_1.JobStatus.FAILED;
        }
        if (!asset.isVisible) {
            return enum_1.JobStatus.SKIPPED;
        }
        const embedding = await this.machineLearningRepository.encodeImage(machineLearning.urls, asset.files[0].path, machineLearning.clip);
        if (this.databaseRepository.isBusy(enum_1.DatabaseLock.CLIPDimSize)) {
            this.logger.verbose(`Waiting for CLIP dimension size to be updated`);
            await this.databaseRepository.wait(enum_1.DatabaseLock.CLIPDimSize);
        }
        await this.searchRepository.upsert(asset.id, embedding);
        return enum_1.JobStatus.SUCCESS;
    }
};
exports.SmartInfoService = SmartInfoService;
__decorate([
    (0, decorators_1.OnEvent)({ name: 'config.init', workers: [enum_1.ImmichWorker.MICROSERVICES] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SmartInfoService.prototype, "onConfigInit", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'config.update', workers: [enum_1.ImmichWorker.MICROSERVICES], server: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SmartInfoService.prototype, "onConfigUpdate", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'config.validate' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], SmartInfoService.prototype, "onConfigValidate", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.QUEUE_SMART_SEARCH, queue: enum_1.QueueName.SMART_SEARCH }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SmartInfoService.prototype, "handleQueueEncodeClip", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.SMART_SEARCH, queue: enum_1.QueueName.SMART_SEARCH }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SmartInfoService.prototype, "handleEncodeClip", null);
exports.SmartInfoService = SmartInfoService = __decorate([
    (0, common_1.Injectable)()
], SmartInfoService);
//# sourceMappingURL=smart-info.service.js.map