import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { PersonResponseDto } from 'src/dtos/person.dto';
import { MetadataSearchDto, PlacesResponseDto, RandomSearchDto, SearchPeopleDto, SearchPlacesDto, SearchResponseDto, SearchSuggestionRequestDto, SmartSearchDto } from 'src/dtos/search.dto';
import { SearchExploreItem } from 'src/repositories/search.repository';
import { BaseService } from 'src/services/base.service';
export declare class SearchService extends BaseService {
    searchPerson(auth: AuthDto, dto: SearchPeopleDto): Promise<PersonResponseDto[]>;
    searchPlaces(dto: SearchPlacesDto): Promise<PlacesResponseDto[]>;
    getExploreData(auth: AuthDto): Promise<SearchExploreItem<AssetResponseDto>[]>;
    searchMetadata(auth: AuthDto, dto: MetadataSearchDto): Promise<SearchResponseDto>;
    searchRandom(auth: AuthDto, dto: RandomSearchDto): Promise<AssetResponseDto[]>;
    searchSmart(auth: AuthDto, dto: SmartSearchDto): Promise<SearchResponseDto>;
    getAssetsByCity(auth: AuthDto): Promise<AssetResponseDto[]>;
    getSearchSuggestions(auth: AuthDto, dto: SearchSuggestionRequestDto): Promise<(string | null)[]>;
    private getSuggestions;
    private getUserIdsToSearch;
    private mapResponse;
}
