import { BulkIdResponseDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetFaceCreateDto, AssetFaceDeleteDto, AssetFaceResponseDto, AssetFaceUpdateDto, FaceDto, MergePersonDto, PeopleResponseDto, PeopleUpdateDto, PersonCreateDto, PersonResponseDto, PersonSearchDto, PersonStatisticsResponseDto, PersonUpdateDto } from 'src/dtos/person.dto';
import { JobName, JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
import { ImmichFileResponse } from 'src/utils/file';
export declare class PersonService extends BaseService {
    getAll(auth: AuthDto, dto: PersonSearchDto): Promise<PeopleResponseDto>;
    reassignFaces(auth: AuthDto, personId: string, dto: AssetFaceUpdateDto): Promise<PersonResponseDto[]>;
    reassignFacesById(auth: AuthDto, personId: string, dto: FaceDto): Promise<PersonResponseDto>;
    getFacesById(auth: AuthDto, dto: FaceDto): Promise<AssetFaceResponseDto[]>;
    createNewFeaturePhoto(changeFeaturePhoto: string[]): Promise<void>;
    getById(auth: AuthDto, id: string): Promise<PersonResponseDto>;
    getStatistics(auth: AuthDto, id: string): Promise<PersonStatisticsResponseDto>;
    getThumbnail(auth: AuthDto, id: string): Promise<ImmichFileResponse>;
    create(auth: AuthDto, dto: PersonCreateDto): Promise<PersonResponseDto>;
    update(auth: AuthDto, id: string, dto: PersonUpdateDto): Promise<PersonResponseDto>;
    updateAll(auth: AuthDto, dto: PeopleUpdateDto): Promise<BulkIdResponseDto[]>;
    private delete;
    handlePersonCleanup(): Promise<JobStatus>;
    handleQueueDetectFaces({ force }: JobOf<JobName.QUEUE_FACE_DETECTION>): Promise<JobStatus>;
    handleDetectFaces({ id }: JobOf<JobName.FACE_DETECTION>): Promise<JobStatus>;
    private iou;
    handleQueueRecognizeFaces({ force, nightly }: JobOf<JobName.QUEUE_FACIAL_RECOGNITION>): Promise<JobStatus>;
    handleRecognizeFaces({ id, deferred }: JobOf<JobName.FACIAL_RECOGNITION>): Promise<JobStatus>;
    handlePersonMigration({ id }: JobOf<JobName.MIGRATE_PERSON>): Promise<JobStatus>;
    handleGeneratePersonThumbnail({ id }: JobOf<JobName.GENERATE_PERSON_THUMBNAIL>): Promise<JobStatus>;
    mergePerson(auth: AuthDto, id: string, dto: MergePersonDto): Promise<BulkIdResponseDto[]>;
    private findOrFail;
    private getInputDimensions;
    private getCrop;
    createFace(auth: AuthDto, dto: AssetFaceCreateDto): Promise<void>;
    deleteFace(auth: AuthDto, id: string, dto: AssetFaceDeleteDto): Promise<void>;
}
