"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var NotificationService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationService = void 0;
const common_1 = require("@nestjs/common");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const email_repository_1 = require("../repositories/email.repository");
const base_service_1 = require("./base.service");
const file_1 = require("../utils/file");
const misc_1 = require("../utils/misc");
const object_1 = require("../utils/object");
const preferences_1 = require("../utils/preferences");
let NotificationService = class NotificationService extends base_service_1.BaseService {
    static { NotificationService_1 = this; }
    static albumUpdateEmailDelayMs = 300_000;
    onConfigUpdate({ oldConfig, newConfig }) {
        this.eventRepository.clientBroadcast('on_config_update');
        this.eventRepository.serverSend('config.update', { oldConfig, newConfig });
    }
    async onConfigValidate({ oldConfig, newConfig }) {
        try {
            if (newConfig.notifications.smtp.enabled &&
                !(0, object_1.isEqualObject)(oldConfig.notifications.smtp, newConfig.notifications.smtp)) {
                await this.emailRepository.verifySmtp(newConfig.notifications.smtp.transport);
            }
        }
        catch (error) {
            this.logger.error(`Failed to validate SMTP configuration: ${error}`, error?.stack);
            throw new Error(`Invalid SMTP configuration: ${error}`);
        }
    }
    onAssetHide({ assetId, userId }) {
        this.eventRepository.clientSend('on_asset_hidden', userId, assetId);
    }
    async onAssetShow({ assetId }) {
        await this.jobRepository.queue({ name: enum_1.JobName.GENERATE_THUMBNAILS, data: { id: assetId, notify: true } });
    }
    onAssetTrash({ assetId, userId }) {
        this.eventRepository.clientSend('on_asset_trash', userId, [assetId]);
    }
    onAssetDelete({ assetId, userId }) {
        this.eventRepository.clientSend('on_asset_delete', userId, assetId);
    }
    onAssetsTrash({ assetIds, userId }) {
        this.eventRepository.clientSend('on_asset_trash', userId, assetIds);
    }
    onAssetsRestore({ assetIds, userId }) {
        this.eventRepository.clientSend('on_asset_restore', userId, assetIds);
    }
    onStackCreate({ userId }) {
        this.eventRepository.clientSend('on_asset_stack_update', userId);
    }
    onStackUpdate({ userId }) {
        this.eventRepository.clientSend('on_asset_stack_update', userId);
    }
    onStackDelete({ userId }) {
        this.eventRepository.clientSend('on_asset_stack_update', userId);
    }
    onStacksDelete({ userId }) {
        this.eventRepository.clientSend('on_asset_stack_update', userId);
    }
    async onUserSignup({ notify, id, tempPassword }) {
        if (notify) {
            await this.jobRepository.queue({ name: enum_1.JobName.NOTIFY_SIGNUP, data: { id, tempPassword } });
        }
    }
    async onAlbumUpdate({ id, recipientIds }) {
        if (recipientIds.length === 0) {
            return;
        }
        const job = {
            name: enum_1.JobName.NOTIFY_ALBUM_UPDATE,
            data: { id, recipientIds, delay: NotificationService_1.albumUpdateEmailDelayMs },
        };
        const previousJobData = await this.jobRepository.removeJob(id, enum_1.JobName.NOTIFY_ALBUM_UPDATE);
        if (previousJobData && this.isAlbumUpdateJob(previousJobData)) {
            for (const id of previousJobData.recipientIds) {
                if (!recipientIds.includes(id)) {
                    recipientIds.push(id);
                }
            }
        }
        await this.jobRepository.queue(job);
    }
    isAlbumUpdateJob(job) {
        return 'recipientIds' in job;
    }
    async onAlbumInvite({ id, userId }) {
        await this.jobRepository.queue({ name: enum_1.JobName.NOTIFY_ALBUM_INVITE, data: { id, recipientId: userId } });
    }
    onSessionDelete({ sessionId }) {
        setTimeout(() => this.eventRepository.clientSend('on_session_delete', sessionId, sessionId), 500);
    }
    async sendTestEmail(id, dto, tempTemplate) {
        const user = await this.userRepository.get(id, { withDeleted: false });
        if (!user) {
            throw new Error('User not found');
        }
        try {
            await this.emailRepository.verifySmtp(dto.transport);
        }
        catch (error) {
            throw new common_1.BadRequestException('Failed to verify SMTP configuration', { cause: error });
        }
        const { server } = await this.getConfig({ withCache: false });
        const { html, text } = await this.emailRepository.renderEmail({
            template: email_repository_1.EmailTemplate.TEST_EMAIL,
            data: {
                baseUrl: (0, misc_1.getExternalDomain)(server),
                displayName: user.name,
            },
            customTemplate: tempTemplate,
        });
        const { messageId } = await this.emailRepository.sendEmail({
            to: user.email,
            subject: 'Test email from Immich',
            html,
            text,
            from: dto.from,
            replyTo: dto.replyTo || dto.from,
            smtp: dto.transport,
        });
        return { messageId };
    }
    async getTemplate(name, customTemplate) {
        const { server, templates } = await this.getConfig({ withCache: false });
        let templateResponse = '';
        switch (name) {
            case email_repository_1.EmailTemplate.WELCOME: {
                const { html: _welcomeHtml } = await this.emailRepository.renderEmail({
                    template: email_repository_1.EmailTemplate.WELCOME,
                    data: {
                        baseUrl: (0, misc_1.getExternalDomain)(server),
                        displayName: 'John Doe',
                        username: 'john@doe.com',
                        password: 'thisIsAPassword123',
                    },
                    customTemplate: customTemplate || templates.email.welcomeTemplate,
                });
                templateResponse = _welcomeHtml;
                break;
            }
            case email_repository_1.EmailTemplate.ALBUM_UPDATE: {
                const { html: _updateAlbumHtml } = await this.emailRepository.renderEmail({
                    template: email_repository_1.EmailTemplate.ALBUM_UPDATE,
                    data: {
                        baseUrl: (0, misc_1.getExternalDomain)(server),
                        albumId: '1',
                        albumName: 'Favorite Photos',
                        recipientName: 'Jane Doe',
                        cid: undefined,
                    },
                    customTemplate: customTemplate || templates.email.albumInviteTemplate,
                });
                templateResponse = _updateAlbumHtml;
                break;
            }
            case email_repository_1.EmailTemplate.ALBUM_INVITE: {
                const { html } = await this.emailRepository.renderEmail({
                    template: email_repository_1.EmailTemplate.ALBUM_INVITE,
                    data: {
                        baseUrl: (0, misc_1.getExternalDomain)(server),
                        albumId: '1',
                        albumName: "John Doe's Favorites",
                        senderName: 'John Doe',
                        recipientName: 'Jane Doe',
                        cid: undefined,
                    },
                    customTemplate: customTemplate || templates.email.albumInviteTemplate,
                });
                templateResponse = html;
                break;
            }
            default: {
                templateResponse = '';
                break;
            }
        }
        return { name, html: templateResponse };
    }
    async handleUserSignup({ id, tempPassword }) {
        const user = await this.userRepository.get(id, { withDeleted: false });
        if (!user) {
            return enum_1.JobStatus.SKIPPED;
        }
        const { server, templates } = await this.getConfig({ withCache: true });
        const { html, text } = await this.emailRepository.renderEmail({
            template: email_repository_1.EmailTemplate.WELCOME,
            data: {
                baseUrl: (0, misc_1.getExternalDomain)(server),
                displayName: user.name,
                username: user.email,
                password: tempPassword,
            },
            customTemplate: templates.email.welcomeTemplate,
        });
        await this.jobRepository.queue({
            name: enum_1.JobName.SEND_EMAIL,
            data: {
                to: user.email,
                subject: 'Welcome to Immich',
                html,
                text,
            },
        });
        return enum_1.JobStatus.SUCCESS;
    }
    async handleAlbumInvite({ id, recipientId }) {
        const album = await this.albumRepository.getById(id, { withAssets: false });
        if (!album) {
            return enum_1.JobStatus.SKIPPED;
        }
        const recipient = await this.userRepository.get(recipientId, { withDeleted: false });
        if (!recipient) {
            return enum_1.JobStatus.SKIPPED;
        }
        const { emailNotifications } = (0, preferences_1.getPreferences)(recipient.email, recipient.metadata);
        if (!emailNotifications.enabled || !emailNotifications.albumInvite) {
            return enum_1.JobStatus.SKIPPED;
        }
        const attachment = await this.getAlbumThumbnailAttachment(album);
        const { server, templates } = await this.getConfig({ withCache: false });
        const { html, text } = await this.emailRepository.renderEmail({
            template: email_repository_1.EmailTemplate.ALBUM_INVITE,
            data: {
                baseUrl: (0, misc_1.getExternalDomain)(server),
                albumId: album.id,
                albumName: album.albumName,
                senderName: album.owner.name,
                recipientName: recipient.name,
                cid: attachment ? attachment.cid : undefined,
            },
            customTemplate: templates.email.albumInviteTemplate,
        });
        await this.jobRepository.queue({
            name: enum_1.JobName.SEND_EMAIL,
            data: {
                to: recipient.email,
                subject: `You have been added to a shared album - ${album.albumName}`,
                html,
                text,
                imageAttachments: attachment ? [attachment] : undefined,
            },
        });
        return enum_1.JobStatus.SUCCESS;
    }
    async handleAlbumUpdate({ id, recipientIds }) {
        const album = await this.albumRepository.getById(id, { withAssets: false });
        if (!album) {
            return enum_1.JobStatus.SKIPPED;
        }
        const owner = await this.userRepository.get(album.ownerId, { withDeleted: false });
        if (!owner) {
            return enum_1.JobStatus.SKIPPED;
        }
        const recipients = [...album.albumUsers.map((user) => user.user), owner].filter((user) => recipientIds.includes(user.id));
        const attachment = await this.getAlbumThumbnailAttachment(album);
        const { server, templates } = await this.getConfig({ withCache: false });
        for (const recipient of recipients) {
            const user = await this.userRepository.get(recipient.id, { withDeleted: false });
            if (!user) {
                continue;
            }
            const { emailNotifications } = (0, preferences_1.getPreferences)(user.email, user.metadata);
            if (!emailNotifications.enabled || !emailNotifications.albumUpdate) {
                continue;
            }
            const { html, text } = await this.emailRepository.renderEmail({
                template: email_repository_1.EmailTemplate.ALBUM_UPDATE,
                data: {
                    baseUrl: (0, misc_1.getExternalDomain)(server),
                    albumId: album.id,
                    albumName: album.albumName,
                    recipientName: recipient.name,
                    cid: attachment ? attachment.cid : undefined,
                },
                customTemplate: templates.email.albumUpdateTemplate,
            });
            await this.jobRepository.queue({
                name: enum_1.JobName.SEND_EMAIL,
                data: {
                    to: recipient.email,
                    subject: `New media has been added to an album - ${album.albumName}`,
                    html,
                    text,
                    imageAttachments: attachment ? [attachment] : undefined,
                },
            });
        }
        return enum_1.JobStatus.SUCCESS;
    }
    async handleSendEmail(data) {
        const { notifications } = await this.getConfig({ withCache: false });
        if (!notifications.smtp.enabled) {
            return enum_1.JobStatus.SKIPPED;
        }
        const { to, subject, html, text: plain } = data;
        const response = await this.emailRepository.sendEmail({
            to,
            subject,
            html,
            text: plain,
            from: notifications.smtp.from,
            replyTo: notifications.smtp.replyTo || notifications.smtp.from,
            smtp: notifications.smtp.transport,
            imageAttachments: data.imageAttachments,
        });
        this.logger.log(`Sent mail with id: ${response.messageId} status: ${response.response}`);
        return enum_1.JobStatus.SUCCESS;
    }
    async getAlbumThumbnailAttachment(album) {
        if (!album.albumThumbnailAssetId) {
            return;
        }
        const albumThumbnailFiles = await this.assetJobRepository.getAlbumThumbnailFiles(album.albumThumbnailAssetId, enum_1.AssetFileType.THUMBNAIL);
        if (albumThumbnailFiles.length !== 1) {
            return;
        }
        return {
            filename: `album-thumbnail${(0, file_1.getFilenameExtension)(albumThumbnailFiles[0].path)}`,
            path: albumThumbnailFiles[0].path,
            cid: 'album-thumbnail',
        };
    }
};
exports.NotificationService = NotificationService;
__decorate([
    (0, decorators_1.OnEvent)({ name: 'config.update' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onConfigUpdate", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'config.validate', priority: -100 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationService.prototype, "onConfigValidate", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'asset.hide' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onAssetHide", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'asset.show' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationService.prototype, "onAssetShow", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'asset.trash' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onAssetTrash", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'asset.delete' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onAssetDelete", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'assets.trash' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onAssetsTrash", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'assets.restore' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onAssetsRestore", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'stack.create' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onStackCreate", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'stack.update' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onStackUpdate", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'stack.delete' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onStackDelete", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'stacks.delete' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onStacksDelete", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'user.signup' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationService.prototype, "onUserSignup", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'album.update' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationService.prototype, "onAlbumUpdate", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'album.invite' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationService.prototype, "onAlbumInvite", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'session.delete' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], NotificationService.prototype, "onSessionDelete", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.NOTIFY_SIGNUP, queue: enum_1.QueueName.NOTIFICATION }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationService.prototype, "handleUserSignup", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.NOTIFY_ALBUM_INVITE, queue: enum_1.QueueName.NOTIFICATION }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationService.prototype, "handleAlbumInvite", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.NOTIFY_ALBUM_UPDATE, queue: enum_1.QueueName.NOTIFICATION }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationService.prototype, "handleAlbumUpdate", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.SEND_EMAIL, queue: enum_1.QueueName.NOTIFICATION }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationService.prototype, "handleSendEmail", null);
exports.NotificationService = NotificationService = NotificationService_1 = __decorate([
    (0, common_1.Injectable)()
], NotificationService);
//# sourceMappingURL=notification.service.js.map