import { SystemConfigSmtpDto } from 'src/dtos/system-config.dto';
import { JobName, JobStatus } from 'src/enum';
import { EmailTemplate } from 'src/repositories/email.repository';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class NotificationService extends BaseService {
    private static albumUpdateEmailDelayMs;
    onConfigUpdate({ oldConfig, newConfig }: ArgOf<'config.update'>): void;
    onConfigValidate({ oldConfig, newConfig }: ArgOf<'config.validate'>): Promise<void>;
    onAssetHide({ assetId, userId }: ArgOf<'asset.hide'>): void;
    onAssetShow({ assetId }: ArgOf<'asset.show'>): Promise<void>;
    onAssetTrash({ assetId, userId }: ArgOf<'asset.trash'>): void;
    onAssetDelete({ assetId, userId }: ArgOf<'asset.delete'>): void;
    onAssetsTrash({ assetIds, userId }: ArgOf<'assets.trash'>): void;
    onAssetsRestore({ assetIds, userId }: ArgOf<'assets.restore'>): void;
    onStackCreate({ userId }: ArgOf<'stack.create'>): void;
    onStackUpdate({ userId }: ArgOf<'stack.update'>): void;
    onStackDelete({ userId }: ArgOf<'stack.delete'>): void;
    onStacksDelete({ userId }: ArgOf<'stacks.delete'>): void;
    onUserSignup({ notify, id, tempPassword }: ArgOf<'user.signup'>): Promise<void>;
    onAlbumUpdate({ id, recipientIds }: ArgOf<'album.update'>): Promise<void>;
    private isAlbumUpdateJob;
    onAlbumInvite({ id, userId }: ArgOf<'album.invite'>): Promise<void>;
    onSessionDelete({ sessionId }: ArgOf<'session.delete'>): void;
    sendTestEmail(id: string, dto: SystemConfigSmtpDto, tempTemplate?: string): Promise<{
        messageId: string;
    }>;
    getTemplate(name: EmailTemplate, customTemplate: string): Promise<{
        name: EmailTemplate;
        html: string;
    }>;
    handleUserSignup({ id, tempPassword }: JobOf<JobName.NOTIFY_SIGNUP>): Promise<JobStatus.SUCCESS | JobStatus.SKIPPED>;
    handleAlbumInvite({ id, recipientId }: JobOf<JobName.NOTIFY_ALBUM_INVITE>): Promise<JobStatus.SUCCESS | JobStatus.SKIPPED>;
    handleAlbumUpdate({ id, recipientIds }: JobOf<JobName.NOTIFY_ALBUM_UPDATE>): Promise<JobStatus.SUCCESS | JobStatus.SKIPPED>;
    handleSendEmail(data: JobOf<JobName.SEND_EMAIL>): Promise<JobStatus>;
    private getAlbumThumbnailAttachment;
}
