import { JobName, JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class MetadataService extends BaseService {
    onBootstrap(): Promise<void>;
    onShutdown(): Promise<void>;
    onConfigInit({ newConfig }: ArgOf<'config.init'>): void;
    onConfigUpdate({ newConfig }: ArgOf<'config.update'>): void;
    private init;
    private linkLivePhotos;
    handleQueueMetadataExtraction(job: JobOf<JobName.QUEUE_METADATA_EXTRACTION>): Promise<JobStatus>;
    handleMetadataExtraction(data: JobOf<JobName.METADATA_EXTRACTION>): Promise<JobStatus>;
    handleQueueSidecar(job: JobOf<JobName.QUEUE_SIDECAR>): Promise<JobStatus>;
    handleSidecarSync({ id }: JobOf<JobName.SIDECAR_SYNC>): Promise<JobStatus>;
    handleSidecarDiscovery({ id }: JobOf<JobName.SIDECAR_DISCOVERY>): Promise<JobStatus>;
    handleTagAsset({ assetId }: ArgOf<'asset.tag'>): Promise<void>;
    handleUntagAsset({ assetId }: ArgOf<'asset.untag'>): Promise<void>;
    handleSidecarWrite(job: JobOf<JobName.SIDECAR_WRITE>): Promise<JobStatus>;
    private getImageDimensions;
    private getExifTags;
    private mergeExifTags;
    private getTagList;
    private applyTagList;
    private isMotionPhoto;
    private applyMotionPhotos;
    private hasTaggedFaces;
    private applyTaggedFaces;
    private getDates;
    private hasGeo;
    private getAutoStackId;
    private getBitsPerSample;
    private getVideoTags;
    private processSidecar;
}
