import { Exif } from 'src/database';
import { JobName, JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
import { JobOf, VideoInterfaces } from 'src/types';
export declare class MediaService extends BaseService {
    videoInterfaces: VideoInterfaces;
    onBootstrap(): Promise<void>;
    handleQueueGenerateThumbnails({ force }: JobOf<JobName.QUEUE_GENERATE_THUMBNAILS>): Promise<JobStatus>;
    handleQueueMigration(): Promise<JobStatus>;
    handleAssetMigration({ id }: JobOf<JobName.MIGRATE_ASSET>): Promise<JobStatus>;
    handleGenerateThumbnails({ id }: JobOf<JobName.GENERATE_THUMBNAILS>): Promise<JobStatus>;
    private generateImageThumbnails;
    private generateVideoThumbnails;
    handleQueueVideoConversion(job: JobOf<JobName.QUEUE_VIDEO_CONVERSION>): Promise<JobStatus>;
    handleVideoConversion({ id }: JobOf<JobName.VIDEO_CONVERSION>): Promise<JobStatus>;
    private getMainStream;
    private getTranscodeTarget;
    private isAudioTranscodeRequired;
    private isVideoTranscodeRequired;
    private isRemuxRequired;
    isSRGB(asset: {
        exifInfo: Exif;
    }): boolean;
    private parseBitrateToBps;
    private shouldUseExtractedImage;
    private getDevices;
    private hasMaliOpenCL;
}
